/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb.metrics;

import io.debezium.annotation.ThreadSafe;
import io.debezium.connector.base.ChangeEventQueueMetrics;
import io.debezium.connector.common.CdcSourceTaskContext;
import io.debezium.connector.mongodb.DisconnectEvent;
import io.debezium.connector.mongodb.MongoDbPartition;
import io.debezium.connector.mongodb.PrimaryElectionEvent;
import io.debezium.connector.mongodb.metrics.MongoDbStreamingChangeEventSourceMetricsMBean;
import io.debezium.pipeline.ConnectorEvent;
import io.debezium.pipeline.metrics.DefaultStreamingChangeEventSourceMetrics;
import io.debezium.pipeline.source.spi.EventMetadataProvider;
import io.debezium.util.Collect;
import java.util.concurrent.atomic.AtomicLong;

@ThreadSafe
public class MongoDbStreamingChangeEventSourceMetrics
extends DefaultStreamingChangeEventSourceMetrics<MongoDbPartition>
implements MongoDbStreamingChangeEventSourceMetricsMBean {
    private AtomicLong numberOfPrimaryElections = new AtomicLong();
    private AtomicLong numberOfDisconnects = new AtomicLong();

    <T extends CdcSourceTaskContext> MongoDbStreamingChangeEventSourceMetrics(T taskContext, ChangeEventQueueMetrics changeEventQueueMetrics, EventMetadataProvider eventMetadataProvider) {
        super(taskContext, changeEventQueueMetrics, eventMetadataProvider, Collect.linkMapOf((Object)"context", (Object)"streaming", (Object)"server", (Object)taskContext.getConnectorName(), (Object)"task", (Object)taskContext.getTaskId()));
    }

    @Override
    public long getNumberOfPrimaryElections() {
        return this.numberOfPrimaryElections.get();
    }

    @Override
    public long getNumberOfDisconnects() {
        return this.numberOfDisconnects.get();
    }

    public void onConnectorEvent(MongoDbPartition partition, ConnectorEvent event) {
        if (event instanceof PrimaryElectionEvent) {
            this.numberOfPrimaryElections.incrementAndGet();
        } else if (event instanceof DisconnectEvent) {
            this.numberOfDisconnects.incrementAndGet();
        }
    }

    public void reset() {
        super.reset();
        this.numberOfPrimaryElections.set(0L);
        this.numberOfDisconnects.set(0L);
    }
}

