/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb.connection;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.ReadPreference;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import io.debezium.annotation.ThreadSafe;
import io.debezium.connector.mongodb.connection.ReplicaSet;
import java.util.function.Consumer;

@ThreadSafe
public final class MongoDbClientFactory {
    private final MongoClientSettings defaultSettings;

    public static MongoDbClientFactory create(Consumer<MongoClientSettings.Builder> configurator) {
        MongoClientSettings.Builder settings = MongoClientSettings.builder();
        configurator.accept(settings);
        return new MongoDbClientFactory(settings);
    }

    private MongoDbClientFactory(MongoClientSettings.Builder settings) {
        this.defaultSettings = settings.build();
    }

    private MongoClientSettings.Builder settings() {
        return MongoClientSettings.builder((MongoClientSettings)this.defaultSettings);
    }

    public MongoClient client(ConnectionString connectionString) {
        return this.client((MongoClientSettings.Builder settings) -> settings.applyConnectionString(connectionString));
    }

    public MongoClient client(ReplicaSet replicaSet, ReadPreference preference) {
        return this.client((MongoClientSettings.Builder settings) -> settings.applyConnectionString(replicaSet.connectionString()).readPreference(preference));
    }

    private MongoClient client(Consumer<MongoClientSettings.Builder> configurator) {
        MongoClientSettings.Builder settings = this.settings();
        configurator.accept(settings);
        return MongoClients.create((MongoClientSettings)settings.build());
    }
}

