/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.db2;

import io.debezium.connector.db2.Db2ConnectorConfig;
import io.debezium.connector.db2.Db2Partition;
import io.debezium.data.Envelope;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.Partition;
import io.debezium.relational.RelationalChangeRecordEmitter;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.util.Clock;

public class Db2ChangeRecordEmitter
extends RelationalChangeRecordEmitter<Db2Partition> {
    public static final int OP_DELETE = 1;
    public static final int OP_INSERT = 2;
    public static final int OP_UPDATE_BEFORE = 3;
    public static final int OP_UPDATE_AFTER = 4;
    public static final int OP_UPDATE_SINGLE = 5;
    private final int operation;
    private final Object[] data;
    private final Object[] dataNext;

    public Db2ChangeRecordEmitter(Db2Partition partition, OffsetContext offset, int operation, Object[] data, Object[] dataNext, Clock clock, Db2ConnectorConfig connectorConfig) {
        super((Partition)partition, offset, clock, (RelationalDatabaseConnectorConfig)connectorConfig);
        this.operation = operation;
        this.data = data;
        this.dataNext = dataNext;
    }

    public Envelope.Operation getOperation() {
        if (this.operation == 1) {
            return Envelope.Operation.DELETE;
        }
        if (this.operation == 2) {
            return Envelope.Operation.CREATE;
        }
        if (this.operation == 3) {
            return Envelope.Operation.UPDATE;
        }
        if (this.operation == 5) {
            return Envelope.Operation.UPDATE;
        }
        throw new IllegalArgumentException("Received event of unexpected command type: " + this.operation);
    }

    protected Object[] getOldColumnValues() {
        switch (this.getOperation()) {
            case CREATE: 
            case READ: {
                return null;
            }
        }
        return this.data;
    }

    protected Object[] getNewColumnValues() {
        switch (this.getOperation()) {
            case CREATE: 
            case READ: {
                return this.data;
            }
            case UPDATE: {
                return this.dataNext;
            }
        }
        return null;
    }
}

