/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.db2;

import io.debezium.DebeziumException;
import io.debezium.connector.db2.Db2Connection;
import io.debezium.connector.db2.Db2ValueConverters;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.relational.Column;
import io.debezium.relational.DefaultValueConverter;
import io.debezium.relational.ValueConverter;
import io.debezium.util.Strings;
import java.sql.Connection;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Db2DefaultValueConverter
implements DefaultValueConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(Db2DefaultValueConverter.class);
    private final Db2ValueConverters valueConverters;
    private final Map<Integer, DefaultValueConverter.DefaultValueMapper> defaultValueMappers;

    public Db2DefaultValueConverter(Db2ValueConverters valueConverters, Db2Connection jdbcConnection) {
        this.valueConverters = valueConverters;
        this.defaultValueMappers = Collections.unmodifiableMap(Db2DefaultValueConverter.createDefaultValueMappers(jdbcConnection));
    }

    public Optional<Object> parseDefaultValue(Column column, String defaultValue) {
        LOGGER.info("Parsing default value for column '{}' with expression '{}'", (Object)column.name(), (Object)defaultValue);
        int dataType = column.jdbcType();
        DefaultValueConverter.DefaultValueMapper mapper = this.defaultValueMappers.get(dataType);
        if (mapper == null) {
            LOGGER.warn("Mapper for type '{}' not found.", (Object)dataType);
            return Optional.empty();
        }
        try {
            Object rawDefaultValue = mapper.parse(column, defaultValue != null ? defaultValue.trim() : defaultValue);
            Object convertedDefaultValue = this.convertDefaultValue(rawDefaultValue, column);
            if (convertedDefaultValue instanceof Struct) {
                LOGGER.warn("Struct can't be used as default value for column '{}', will use null instead.", (Object)column.name());
                return Optional.empty();
            }
            return Optional.ofNullable(convertedDefaultValue);
        }
        catch (Exception e) {
            LOGGER.warn("Cannot parse column default value '{}' to type '{}'.  Expression evaluation is not supported.", new Object[]{defaultValue, dataType, e});
            LOGGER.debug("Parsing failed due to error", (Throwable)e);
            return Optional.empty();
        }
    }

    private Object convertDefaultValue(Object defaultValue, Column column) {
        SchemaBuilder schemaBuilder;
        if (this.valueConverters != null && defaultValue != null && (schemaBuilder = this.valueConverters.schemaBuilder(column)) != null) {
            Schema schema = schemaBuilder.build();
            Field field = new Field(column.name(), -1, schema);
            ValueConverter valueConverter = this.valueConverters.converter(column, field);
            return valueConverter.convert(defaultValue);
        }
        return defaultValue;
    }

    private static Map<Integer, DefaultValueConverter.DefaultValueMapper> createDefaultValueMappers(Db2Connection connection) {
        HashMap<Integer, DefaultValueConverter.DefaultValueMapper> result = new HashMap<Integer, DefaultValueConverter.DefaultValueMapper>();
        result.put(16, Db2DefaultValueConverter.nullableDefaultValueMapper(Db2DefaultValueConverter.booleanDefaultValueMapper()));
        result.put(-5, Db2DefaultValueConverter.nullableDefaultValueMapper());
        result.put(2, Db2DefaultValueConverter.nullableDefaultValueMapper());
        result.put(4, Db2DefaultValueConverter.nullableDefaultValueMapper());
        result.put(5, Db2DefaultValueConverter.nullableDefaultValueMapper());
        result.put(3, Db2DefaultValueConverter.nullableDefaultValueMapper());
        result.put(8, Db2DefaultValueConverter.nullableDefaultValueMapper((c, v) -> Double.parseDouble(v)));
        result.put(7, Db2DefaultValueConverter.nullableDefaultValueMapper((c, v) -> Float.valueOf(Float.parseFloat(v))));
        result.put(91, Db2DefaultValueConverter.nullableDefaultValueMapper(Db2DefaultValueConverter.castTemporalFunctionCall(connection, 91)));
        result.put(92, Db2DefaultValueConverter.nullableDefaultValueMapper(Db2DefaultValueConverter.castTemporalFunctionCall(connection, 92)));
        result.put(93, Db2DefaultValueConverter.nullableDefaultValueMapper(Db2DefaultValueConverter.castTemporalFunctionCall(connection, 93)));
        result.put(1, Db2DefaultValueConverter.nullableDefaultValueMapper(Db2DefaultValueConverter.enforceCharFieldPadding()));
        result.put(12, Db2DefaultValueConverter.nullableDefaultValueMapper(Db2DefaultValueConverter.enforceStringUnquote()));
        result.put(-15, Db2DefaultValueConverter.nullableDefaultValueMapper(Db2DefaultValueConverter.enforceCharFieldPadding()));
        result.put(-9, Db2DefaultValueConverter.nullableDefaultValueMapper(Db2DefaultValueConverter.enforceStringUnquote()));
        return result;
    }

    private static DefaultValueConverter.DefaultValueMapper nullableDefaultValueMapper() {
        return Db2DefaultValueConverter.nullableDefaultValueMapper(null);
    }

    private static DefaultValueConverter.DefaultValueMapper nullableDefaultValueMapper(DefaultValueConverter.DefaultValueMapper mapper) {
        return (column, value) -> {
            if ("NULL".equalsIgnoreCase(value)) {
                return null;
            }
            if (mapper != null) {
                return mapper.parse(column, value);
            }
            return value;
        };
    }

    public static DefaultValueConverter.DefaultValueMapper booleanDefaultValueMapper() {
        return (column, value) -> {
            if ("1".equals(value.trim())) {
                return true;
            }
            if ("0".equals(value.trim())) {
                return false;
            }
            return Boolean.parseBoolean(value.trim());
        };
    }

    private static DefaultValueConverter.DefaultValueMapper castTemporalFunctionCall(Db2Connection connection, int jdbcType) {
        return (column, value) -> {
            if ("CURRENT DATE".equalsIgnoreCase(value.trim())) {
                return column.isOptional() ? null : Long.valueOf(0L);
            }
            if ("CURRENT TIME".equalsIgnoreCase(value.trim())) {
                return column.isOptional() ? null : Time.valueOf("00:00:00");
            }
            if ("CURRENT TIMESTAMP".equalsIgnoreCase(value.trim())) {
                return column.isOptional() ? null : Timestamp.valueOf("1970-01-01 00:00:00");
            }
            switch (jdbcType) {
                case 91: {
                    return JdbcConnection.querySingleValue((Connection)connection.connection(), (String)("SELECT DATE(" + value + ") FROM sysibm.sysdummy1"), st -> {}, rs -> rs.getDate(1));
                }
                case 92: {
                    return JdbcConnection.querySingleValue((Connection)connection.connection(), (String)("SELECT TIME(" + value + ") FROM sysibm.sysdummy1"), st -> {}, rs -> rs.getTime(1));
                }
                case 93: {
                    return JdbcConnection.querySingleValue((Connection)connection.connection(), (String)("SELECT TIMESTAMP(" + value + ") FROM sysibm.sysdummy1"), st -> {}, rs -> rs.getTimestamp(1));
                }
            }
            throw new DebeziumException("Unexpected JDBC type '" + jdbcType + "' for default value resolution: " + value);
        };
    }

    private static DefaultValueConverter.DefaultValueMapper enforceCharFieldPadding() {
        return (column, value) -> value != null ? Strings.pad((String)Db2DefaultValueConverter.unquote(value), (int)column.length(), (char)' ') : null;
    }

    private static DefaultValueConverter.DefaultValueMapper enforceStringUnquote() {
        return (column, value) -> value != null ? Db2DefaultValueConverter.unquote(value) : null;
    }

    private static String unquote(String value) {
        if (value.startsWith("('") && value.endsWith("')")) {
            return value.substring(2, value.length() - 2);
        }
        if (value.startsWith("'") && value.endsWith("'")) {
            return value.substring(1, value.length() - 1);
        }
        return value;
    }
}

