/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cockroachdb;

import io.debezium.config.Field;
import io.debezium.connector.SnapshotRecord;
import io.debezium.connector.cockroachdb.CockroachDBConnectorConfig;
import io.debezium.connector.cockroachdb.SourceInfo;
import io.debezium.connector.common.BaseSourceInfo;
import io.debezium.pipeline.CommonOffsetContext;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.txmetadata.TransactionContext;
import io.debezium.spi.schema.DataCollectionId;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CockroachDBOffsetContext
extends CommonOffsetContext<SourceInfo> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CockroachDBOffsetContext.class);
    public static final String CURSOR = "offset.cursor";
    public static final String TIMESTAMP = "offset.timestamp";
    public static final String SNAPSHOT_COMPLETED_KEY = "snapshot_completed";
    public static final Field CURSOR_FIELD = Field.create((String)"offset.cursor");
    public static final Field TIMESTAMP_FIELD = Field.create((String)"offset.timestamp");
    private final Map<String, String> partition;
    private final CockroachDBConnectorConfig connectorConfig;
    private final SourceInfo sourceInfo;
    private final String logicalName;
    private String cursor;
    private Instant timestamp;
    private TransactionContext transactionContext;
    private Long kafkaOffset;

    public CockroachDBOffsetContext(CockroachDBConnectorConfig connectorConfig) {
        super((BaseSourceInfo)new SourceInfo(connectorConfig), false);
        this.connectorConfig = connectorConfig;
        this.logicalName = connectorConfig.getLogicalName();
        this.partition = Collections.singletonMap("server", this.logicalName);
        this.sourceInfo = new SourceInfo(connectorConfig);
        this.cursor = connectorConfig.getChangefeedCursor();
        this.timestamp = Instant.now();
        this.kafkaOffset = null;
    }

    public CockroachDBOffsetContext(CockroachDBConnectorConfig config, String cursor, Instant timestamp, Long kafkaOffset) {
        super((BaseSourceInfo)new SourceInfo(config), false);
        this.connectorConfig = config;
        this.logicalName = config.getLogicalName();
        this.partition = Collections.singletonMap("server", this.logicalName);
        this.sourceInfo = new SourceInfo(config);
        this.cursor = cursor;
        this.timestamp = timestamp;
        this.kafkaOffset = kafkaOffset;
    }

    public void setTimestamp(Instant timestamp) {
        this.timestamp = timestamp;
        this.sourceInfo.setSourceTime(timestamp);
    }

    public void setTransaction(TransactionContext context) {
        this.transactionContext = context;
    }

    public void endTransaction() {
        this.transactionContext = null;
    }

    public Map<String, ?> getOffset() {
        HashMap<String, Object> offset = new HashMap<String, Object>();
        offset.put(CURSOR, this.cursor != null ? this.cursor : "initial");
        offset.put(TIMESTAMP, this.timestamp.toEpochMilli());
        offset.put(SNAPSHOT_COMPLETED_KEY, Boolean.toString(this.snapshotCompleted));
        return offset;
    }

    public Schema getSourceInfoSchema() {
        return this.sourceInfo.schema();
    }

    public Struct getSourceInfo() {
        return this.sourceInfo.struct();
    }

    public void event(DataCollectionId collectionId, Instant ts) {
        this.setTimestamp(ts);
    }

    public TransactionContext getTransactionContext() {
        return this.transactionContext;
    }

    public String toString() {
        return "CockroachDBOffsetContext [cursor=" + this.cursor + ", ts=" + String.valueOf(this.timestamp) + "]";
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public void markSnapshotRecord(SnapshotRecord record) {
        this.sourceInfo.setSnapshot(record);
    }

    public void setCursor(String cursor) {
        this.cursor = cursor;
    }

    public String getCursor() {
        return this.cursor;
    }

    public Long getKafkaOffset() {
        return this.kafkaOffset;
    }

    public void setKafkaOffset(Long kafkaOffset) {
        this.kafkaOffset = kafkaOffset;
    }

    public static class Loader
    implements OffsetContext.Loader<CockroachDBOffsetContext> {
        private final CockroachDBConnectorConfig connectorConfig;

        public Loader(CockroachDBConnectorConfig connectorConfig) {
            this.connectorConfig = connectorConfig;
        }

        public CockroachDBOffsetContext load(Map<String, ?> offset) {
            CockroachDBOffsetContext context = new CockroachDBOffsetContext(this.connectorConfig);
            String cursor = (String)offset.get(CockroachDBOffsetContext.CURSOR);
            String tsStr = offset.get(CockroachDBOffsetContext.TIMESTAMP) != null ? offset.get(CockroachDBOffsetContext.TIMESTAMP).toString() : null;
            String snapshot = (String)offset.get(CockroachDBOffsetContext.SNAPSHOT_COMPLETED_KEY);
            if (cursor != null) {
                context.setCursor(cursor);
            }
            if (tsStr != null) {
                context.setTimestamp(Instant.ofEpochMilli(Long.parseLong(tsStr)));
            }
            if (snapshot != null) {
                context.snapshotCompleted = Boolean.parseBoolean(snapshot);
            }
            return context;
        }
    }
}

