/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cockroachdb;

import io.debezium.connector.base.ChangeEventQueue;
import io.debezium.connector.cockroachdb.CockroachDBConnectorConfig;
import io.debezium.pipeline.DataChangeEvent;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CockroachDBErrorHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(CockroachDBErrorHandler.class);
    private static final String SERIALIZATION_FAILURE = "40001";
    private static final String DEADLOCK_DETECTED = "40P01";
    private static final String CONNECTION_FAILURE = "08000";
    private static final String CONNECTION_DOES_NOT_EXIST = "08003";
    private static final String CONNECTION_FAILURE_DURING_EXECUTION = "08006";
    private static final String COMMUNICATION_LINK_FAILURE = "08S01";
    private final CockroachDBConnectorConfig config;
    private final ChangeEventQueue<DataChangeEvent> queue;
    private final AtomicReference<Throwable> producerThrowable = new AtomicReference();

    public CockroachDBErrorHandler(CockroachDBConnectorConfig config, ChangeEventQueue<DataChangeEvent> queue) {
        this.config = config;
        this.queue = queue;
    }

    public void setProducerThrowable(Throwable producerThrowable) {
        this.producerThrowable.set(producerThrowable);
    }

    public Throwable getProducerThrowable() {
        return this.producerThrowable.get();
    }

    public void handle(Throwable throwable) {
        SQLException sqlException;
        String sqlState;
        if (throwable instanceof SQLException && this.isTransientError(sqlState = (sqlException = (SQLException)throwable).getSQLState())) {
            LOGGER.warn("Transient SQL error occurred: {} - {}. Will retry.", (Object)sqlState, (Object)sqlException.getMessage());
            return;
        }
        LOGGER.error("Error in CockroachDB connector: ", throwable);
        this.setProducerThrowable(throwable);
    }

    private boolean isTransientError(String sqlState) {
        if (sqlState == null) {
            return false;
        }
        return SERIALIZATION_FAILURE.equals(sqlState) || DEADLOCK_DETECTED.equals(sqlState) || CONNECTION_FAILURE.equals(sqlState) || CONNECTION_DOES_NOT_EXIST.equals(sqlState) || CONNECTION_FAILURE_DURING_EXECUTION.equals(sqlState) || COMMUNICATION_LINK_FAILURE.equals(sqlState);
    }

    public boolean isTransientError(Throwable throwable) {
        if (throwable == null) {
            return false;
        }
        if (throwable instanceof SQLException) {
            return this.isTransientError(((SQLException)throwable).getSQLState());
        }
        String message = throwable.getMessage();
        if (message != null) {
            return (message = message.toLowerCase()).contains("connection") || message.contains("timeout") || message.contains("network") || message.contains("retry") || message.contains("temporary");
        }
        return false;
    }

    public boolean handleConnectionError(Throwable throwable, int attempt, int maxRetries, long retryDelayMs) throws InterruptedException {
        if (throwable == null) {
            LOGGER.warn("Null throwable provided to handleConnectionError");
            return false;
        }
        if (this.isTransientError(throwable) && attempt < maxRetries) {
            LOGGER.warn("Transient connection error (attempt {}/{}): {}. Retrying in {}ms...", new Object[]{attempt, maxRetries, throwable.getMessage(), retryDelayMs});
            Thread.sleep(retryDelayMs);
            return true;
        }
        LOGGER.error("Non-transient connection error or max retries exceeded (attempt {}/{}): {}", new Object[]{attempt, maxRetries, throwable.getMessage()});
        return false;
    }
}

