/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cockroachdb;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.ConfigDefinition;
import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.config.Field;
import io.debezium.connector.AbstractSourceInfo;
import io.debezium.connector.SourceInfoStructMaker;
import io.debezium.connector.cockroachdb.CockroachDBSourceInfoStructMaker;
import io.debezium.connector.cockroachdb.Module;
import io.debezium.jdbc.JdbcConfiguration;
import io.debezium.relational.ColumnFilterMode;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import io.debezium.util.Strings;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.kafka.common.config.ConfigDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CockroachDBConnectorConfig
extends RelationalDatabaseConnectorConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(CockroachDBConnectorConfig.class);
    protected static final String DATABASE_CONFIG_PREFIX = "database.";
    protected static final int DEFAULT_PORT = 26257;
    protected static final int DEFAULT_SNAPSHOT_FETCH_SIZE = 1024;
    public static final Field PORT = RelationalDatabaseConnectorConfig.PORT.withDefault(26257);
    public static final Field SERVER_NAME = Field.create((String)"database.server.name").withDisplayName("Server name").withType(ConfigDef.Type.STRING).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION, (int)0)).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.HIGH).withDescription("Unique name that identifies the database server and all recorded offsets, and is used as a prefix for all Kafka topic names.");
    public static final Field ON_CONNECT_STATEMENTS = Field.create((String)("database." + String.valueOf(JdbcConfiguration.ON_CONNECT_STATEMENTS))).withDisplayName("Initial statements").withType(ConfigDef.Type.STRING).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION_ADVANCED, (int)1)).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.LOW).withDescription("A semicolon separated list of SQL statements to be executed when a JDBC connection to the database is established. Note that the connector may establish JDBC connections at its own discretion, so this should typically be used for configuration of session parameters only, but not for executing DML statements. Use doubled semicolon (';;') to use a semicolon as a character and not as a delimiter.");
    public static final Field SSL_MODE = Field.create((String)"database.sslmode").withDisplayName("SSL mode").withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION_ADVANCED_SSL, (int)0)).withEnum(SecureConnectionMode.class, (Enum)SecureConnectionMode.PREFER).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.MEDIUM).withDescription("Whether to use an encrypted connection to Postgres. Options include: 'disable' (the default) to use an unencrypted connection; 'allow' to try and use an unencrypted connection first and, failing that, a secure (encrypted) connection; 'prefer' (the default) to try and use a secure (encrypted) connection first and, failing that, an unencrypted connection; 'require' to use a secure (encrypted) connection, and fail if one cannot be established; 'verify-ca' like 'required' but additionally verify the server TLS certificate against the configured Certificate Authority (CA) certificates, or fail if no valid matching CA certificates are found; or 'verify-full' like 'verify-ca' but additionally verify that the server certificate matches the host to which the connection is attempted.");
    public static final Field SSL_CLIENT_CERT = Field.create((String)"database.sslcert").withDisplayName("SSL Client Certificate").withType(ConfigDef.Type.STRING).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION_ADVANCED_SSL, (int)1)).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.MEDIUM).withDescription("File containing the SSL Certificate for the client. See the Postgres SSL docs for further information");
    public static final Field SSL_CLIENT_KEY = Field.create((String)"database.sslkey").withDisplayName("SSL Client Key").withType(ConfigDef.Type.STRING).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION_ADVANCED_SSL, (int)4)).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.MEDIUM).withDescription("File containing the SSL private key for the client. See the Postgres SSL docs for further information");
    public static final Field SSL_CLIENT_KEY_PASSWORD = Field.create((String)"database.sslpassword").withDisplayName("SSL Client Key Password").withType(ConfigDef.Type.PASSWORD).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION_ADVANCED_SSL, (int)2)).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.MEDIUM).withDescription("Password to access the client private key from the file specified by 'database.sslkey'. See the Postgres SSL docs for further information");
    public static final Field SSL_ROOT_CERT = Field.create((String)"database.sslrootcert").withDisplayName("SSL Root Certificate").withType(ConfigDef.Type.STRING).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION_ADVANCED_SSL, (int)3)).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.MEDIUM).withDescription("File containing the root certificate(s) against which the server is validated. See the Postgres JDBC SSL docs for further information");
    public static final Field SSL_SOCKET_FACTORY = Field.create((String)"database.sslfactory").withDisplayName("SSL Root Certificate").withType(ConfigDef.Type.STRING).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION_ADVANCED_SSL, (int)5)).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.MEDIUM).withDescription("A name of class to that creates SSL Sockets. Use org.postgresql.ssl.NonValidatingFactory to disable SSL validation in development environments");
    public static final Field TCP_KEEPALIVE = Field.create((String)"database.tcpKeepAlive").withDisplayName("TCP keep-alive probe").withType(ConfigDef.Type.BOOLEAN).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION_ADVANCED, (int)0)).withDefault(true).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDescription("Enable or disable TCP keep-alive probe to avoid dropping TCP connection").withValidation(new Field.Validator[]{Field::isBoolean});
    public static final Field STATUS_UPDATE_INTERVAL_MS = Field.create((String)"status.update.interval.ms").withDisplayName("Status update interval (ms)").withType(ConfigDef.Type.INT).withDefault(10000).withDescription("How often to send status updates to the server in milliseconds.");
    public static final Field SNAPSHOT_MODE = Field.create((String)"snapshot.mode").withDisplayName("Snapshot mode").withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR_SNAPSHOT, (int)0)).withEnum(SnapshotMode.class, (Enum)SnapshotMode.INITIAL).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDescription("The criteria for running a snapshot upon startup of the connector. Select one of the following snapshot options: 'always': The connector runs a snapshot every time that it starts. After the snapshot completes, the connector begins to stream changes from the transaction log.; 'initial' (default): If the connector does not detect any offsets for the logical server name, it runs a snapshot that captures the current full state of the configured tables. After the snapshot completes, the connector begins to stream changes from the transaction log. 'initial_only': The connector performs a snapshot as it does for the 'initial' option, but after the connector completes the snapshot, it stops, and does not stream changes from the transaction log.; 'never': The connector does not run a snapshot. Upon first startup, the connector immediately begins reading from the beginning of the transaction log. 'exported': This option is deprecated; use 'initial' instead.; 'custom': The connector loads a custom class  to specify how the connector performs snapshots. For more information, see Custom snapshotter SPI in the PostgreSQL connector documentation.");
    public static final Field SNAPSHOT_ISOLATION_MODE = Field.create((String)"snapshot.isolation.mode").withDisplayName("Snapshot isolation mode").withEnum(SnapshotIsolationMode.class, (Enum)SnapshotIsolationMode.SERIALIZABLE).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR_SNAPSHOT, (int)1)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDescription("Controls which transaction isolation level is used. The default is '" + SnapshotIsolationMode.SERIALIZABLE.getValue() + "', which means that serializable isolation level is used. When '" + SnapshotIsolationMode.READ_COMMITTED.getValue() + "' is specified, connector runs the initial snapshot in READ COMMITTED isolation level. ");
    public static final Field SNAPSHOT_LOCKING_MODE = Field.create((String)"snapshot.locking.mode").withDisplayName("Snapshot locking mode").withEnum(SnapshotLockingMode.class, (Enum)SnapshotLockingMode.NONE).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR_SNAPSHOT, (int)13)).withDescription("Controls how the connector holds locks on tables while performing the schema snapshot. The 'shared' which means the connector will hold a table lock that prevents exclusive table access for just the initial portion of the snapshot while the database schemas and other metadata are being read. The remaining work in a snapshot involves selecting all rows from each table, and this is done using a flashback query that requires no locks. However, in some cases it may be desirable to avoid locks entirely which can be done by specifying 'none'. This mode is only safe to use if no schema changes are happening while the snapshot is taken.");
    public static final Field SOURCE_INFO_STRUCT_MAKER = CommonConnectorConfig.SOURCE_INFO_STRUCT_MAKER.withDefault(CockroachDBSourceInfoStructMaker.class.getName());
    public static final Field UNAVAILABLE_VALUE_PLACEHOLDER = RelationalDatabaseConnectorConfig.UNAVAILABLE_VALUE_PLACEHOLDER.withDescription("Placeholder for unavailable values (e.g. for toasted columns).");
    public static final Field READ_ONLY_CONNECTION = Field.create((String)"read.only").withDisplayName("Read only connection").withType(ConfigDef.Type.BOOLEAN).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION, (int)100)).withDefault(false).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDescription("Switched connector to use alternative methods to deliver signals to Debezium instead of writing to signaling table");
    public static final Field CHANGEFEED_ENVELOPE = Field.create((String)"cockroachdb.changefeed.envelope").withDisplayName("Changefeed envelope type").withType(ConfigDef.Type.STRING).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR_ADVANCED, (int)0)).withDefault("enriched").withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.HIGH).withDescription("The envelope type for changefeed events. Options: 'enriched', 'wrapped', 'bare'.");
    public static final Field CHANGEFEED_RESOLVED_INTERVAL = Field.create((String)"cockroachdb.changefeed.resolved.interval").withDisplayName("Changefeed resolved interval").withType(ConfigDef.Type.STRING).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR_ADVANCED, (int)1)).withDefault("10s").withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDescription("The interval for resolved timestamp messages. Format: '10s', '1m', etc.");
    public static final Field CHANGEFEED_INCLUDE_UPDATED = Field.create((String)"cockroachdb.changefeed.include.updated").withDisplayName("Include updated column information").withType(ConfigDef.Type.BOOLEAN).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR_ADVANCED, (int)2)).withDefault(false).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDescription("Whether to include information about which columns were updated in UPDATE events.");
    public static final Field CHANGEFEED_INCLUDE_DIFF = Field.create((String)"cockroachdb.changefeed.include.diff").withDisplayName("Include diff information").withType(ConfigDef.Type.BOOLEAN).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR_ADVANCED, (int)3)).withDefault(false).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDescription("Whether to include before/after diff information in changefeed events.");
    public static final Field CHANGEFEED_ENRICHED_PROPERTIES = Field.create((String)"cockroachdb.changefeed.enriched.properties").withDisplayName("Changefeed enriched properties").withType(ConfigDef.Type.STRING).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR_ADVANCED, (int)4)).withDefault("source,schema").withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.MEDIUM).withDescription("Comma-separated list of properties to include in enriched envelope: 'source', 'schema', 'mvcc'.");
    public static final Field CHANGEFEED_CURSOR = Field.create((String)"cockroachdb.changefeed.cursor").withDisplayName("Changefeed cursor").withType(ConfigDef.Type.STRING).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR_ADVANCED, (int)5)).withDefault("now").withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.HIGH).withDescription("The cursor position to start changefeed from. Use 'now' for current time or a timestamp.");
    public static final Field CHANGEFEED_BATCH_SIZE = Field.create((String)"cockroachdb.changefeed.batch.size").withDisplayName("Changefeed batch size").withType(ConfigDef.Type.INT).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR_ADVANCED, (int)5)).withDefault(1000).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDescription("The batch size for changefeed processing.");
    public static final Field CHANGEFEED_POLL_INTERVAL = Field.create((String)"cockroachdb.changefeed.poll.interval.ms").withDisplayName("Changefeed poll interval (ms)").withType(ConfigDef.Type.LONG).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR_ADVANCED, (int)6)).withDefault(100L).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDescription("The poll interval in milliseconds for changefeed processing.");
    public static final Field CHANGEFEED_SINK_TYPE = Field.create((String)"cockroachdb.changefeed.sink.type").withDisplayName("Changefeed sink type").withType(ConfigDef.Type.STRING).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR_ADVANCED, (int)7)).withDefault("kafka").withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.HIGH).withDescription("The type of sink for changefeed events. Options: 'kafka', 'pubsub', 'webhook', 'cloudstorage'.");
    public static final Field CHANGEFEED_SINK_URI = Field.create((String)"cockroachdb.changefeed.sink.uri").withDisplayName("Changefeed sink URI").withType(ConfigDef.Type.STRING).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR_ADVANCED, (int)8)).withDefault("kafka://kafka-test:9092").withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.HIGH).withDescription("The URI for the changefeed sink. Format depends on sink type: 'kafka://host:port' for Kafka, 'pubsub://project:topic' for Pub/Sub, 'webhook://url' for Webhook, 'cloudstorage://bucket' for Cloud Storage.");
    public static final Field CHANGEFEED_SINK_TOPIC_PREFIX = Field.create((String)"cockroachdb.changefeed.sink.topic.prefix").withDisplayName("Changefeed sink topic prefix").withType(ConfigDef.Type.STRING).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR_ADVANCED, (int)9)).withDefault("").withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.MEDIUM).withDescription("Prefix for changefeed topic names. Used to create topics in format: prefix.database.schema.table. For multi-tenant deployments, consider using a unique prefix per tenant. If not specified, defaults to 'cockroachdb'.");
    public static final Field CHANGEFEED_SINK_OPTIONS = Field.create((String)"cockroachdb.changefeed.sink.options").withDisplayName("Changefeed sink options").withType(ConfigDef.Type.STRING).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR_ADVANCED, (int)10)).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.LOW).withDescription("Additional options for the sink in key=value format, comma-separated. Example: 'compression=gzip,retry_count=3'");
    public static final Field CONNECTION_TIMEOUT_MS = Field.create((String)"connection.timeout.ms").withDisplayName("Connection timeout (ms)").withType(ConfigDef.Type.LONG).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION_ADVANCED, (int)10)).withDefault(30000L).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDescription("How long to wait for a connection to be established in milliseconds.");
    public static final Field CONNECTION_RETRY_DELAY_MS = Field.create((String)"connection.retry.delay.ms").withDisplayName("Connection retry delay (ms)").withType(ConfigDef.Type.LONG).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION_ADVANCED, (int)11)).withDefault(100L).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDescription("Delay between connection retry attempts in milliseconds.");
    public static final Field CONNECTION_MAX_RETRIES = Field.create((String)"connection.max.retries").withDisplayName("Connection max retries").withType(ConfigDef.Type.INT).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION_ADVANCED, (int)12)).withDefault(3).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDescription("Maximum number of connection retry attempts before giving up.");
    public static final Field SCHEMA_NAME = Field.create((String)"cockroachdb.schema.name").withDisplayName("Schema name").withType(ConfigDef.Type.STRING).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR_ADVANCED, (int)11)).withDefault("public").withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.MEDIUM).withDescription("The schema name to use for changefeed operations.");
    private static final ConfigDefinition CONFIG_DEFINITION = RelationalDatabaseConnectorConfig.CONFIG_DEFINITION.edit().name("CockroachDB").type(new Field[]{HOSTNAME, PORT, USER, PASSWORD, DATABASE_NAME, SERVER_NAME, ON_CONNECT_STATEMENTS, SSL_MODE, SSL_ROOT_CERT, SSL_CLIENT_CERT, SSL_CLIENT_KEY, SSL_CLIENT_KEY_PASSWORD, TCP_KEEPALIVE, STATUS_UPDATE_INTERVAL_MS, CONNECTION_TIMEOUT_MS, CONNECTION_RETRY_DELAY_MS, CONNECTION_MAX_RETRIES}).events(new Field[]{SOURCE_INFO_STRUCT_MAKER}).connector(new Field[]{SNAPSHOT_MODE, SNAPSHOT_ISOLATION_MODE, SNAPSHOT_LOCKING_MODE, UNAVAILABLE_VALUE_PLACEHOLDER, READ_ONLY_CONNECTION, SCHEMA_NAME, CHANGEFEED_ENVELOPE, CHANGEFEED_RESOLVED_INTERVAL, CHANGEFEED_INCLUDE_UPDATED, CHANGEFEED_INCLUDE_DIFF, CHANGEFEED_ENRICHED_PROPERTIES, CHANGEFEED_CURSOR, CHANGEFEED_BATCH_SIZE, CHANGEFEED_POLL_INTERVAL, CHANGEFEED_SINK_TYPE, CHANGEFEED_SINK_URI, CHANGEFEED_SINK_TOPIC_PREFIX, CHANGEFEED_SINK_OPTIONS}).create();
    public static final Field.Set ALL_FIELDS = Field.setOf((Iterable)CONFIG_DEFINITION.all());
    private final String databaseName;
    private final SnapshotMode snapshotMode;
    private final SnapshotIsolationMode snapshotIsolationMode;
    private final SnapshotLockingMode snapshotLockingMode;
    private final boolean readOnlyConnection;
    protected final Configuration config;

    public CockroachDBConnectorConfig(Configuration config) {
        super(config, (Tables.TableFilter)new SystemTablesPredicate(), x -> x.schema() + "." + x.table(), 1024, ColumnFilterMode.SCHEMA, false);
        this.config = config;
        this.databaseName = config.getString(DATABASE_NAME);
        this.snapshotMode = SnapshotMode.parse(config.getString(SNAPSHOT_MODE));
        this.snapshotIsolationMode = SnapshotIsolationMode.parse(config.getString(SNAPSHOT_ISOLATION_MODE));
        this.snapshotLockingMode = SnapshotLockingMode.parse(config.getString(SNAPSHOT_LOCKING_MODE));
        this.readOnlyConnection = config.getBoolean(READ_ONLY_CONNECTION);
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    protected int port() {
        return this.config.getInteger(PORT);
    }

    public String databaseName() {
        return this.config.getString(DATABASE_NAME);
    }

    public SnapshotMode getSnapshotMode() {
        return this.snapshotMode;
    }

    public SnapshotIsolationMode getSnapshotIsolationMode() {
        return this.snapshotIsolationMode;
    }

    public Optional<SnapshotLockingMode> getSnapshotLockingMode() {
        return Optional.ofNullable(this.snapshotLockingMode);
    }

    public Duration statusUpdateInterval() {
        return Duration.ofMillis(this.config.getLong(STATUS_UPDATE_INTERVAL_MS));
    }

    public byte[] getUnavailableValuePlaceholder() {
        String placeholder = this.config.getString(UNAVAILABLE_VALUE_PLACEHOLDER);
        if (placeholder.startsWith("hex:")) {
            return Strings.hexStringToByteArray((String)placeholder.substring(4));
        }
        return placeholder.getBytes();
    }

    public String getContextName() {
        return Module.contextName();
    }

    public String getConnectorName() {
        return Module.name();
    }

    protected SourceInfoStructMaker<? extends AbstractSourceInfo> getSourceInfoStructMaker(CommonConnectorConfig.Version version) {
        return this.getSourceInfoStructMaker(SOURCE_INFO_STRUCT_MAKER, Module.name(), Module.version(), (CommonConnectorConfig)this);
    }

    public static ConfigDef configDef() {
        return CONFIG_DEFINITION.configDef();
    }

    public String getSslMode() {
        return this.config.getString(SSL_MODE);
    }

    public String getSslRootCert() {
        return this.config.getString(SSL_ROOT_CERT);
    }

    public String getSslClientCert() {
        return this.config.getString(SSL_CLIENT_CERT);
    }

    public String getSslClientKey() {
        return this.config.getString(SSL_CLIENT_KEY);
    }

    public String getSslClientKeyPassword() {
        return this.config.getString(SSL_CLIENT_KEY_PASSWORD);
    }

    public boolean isTcpKeepAlive() {
        return this.config.getBoolean(TCP_KEEPALIVE);
    }

    public String getOnConnectStatements() {
        return this.config.getString(ON_CONNECT_STATEMENTS);
    }

    public boolean isReadOnlyConnection() {
        return this.config.getBoolean(READ_ONLY_CONNECTION);
    }

    public String getHostname() {
        return this.config.getString(HOSTNAME);
    }

    public int getPort() {
        return this.config.getInteger(PORT);
    }

    public String getUser() {
        return this.config.getString(USER);
    }

    public String getPassword() {
        return this.config.getString(RelationalDatabaseConnectorConfig.PASSWORD);
    }

    public String getChangefeedEnvelope() {
        return this.config.getString(CHANGEFEED_ENVELOPE);
    }

    public String getChangefeedResolvedInterval() {
        return this.config.getString(CHANGEFEED_RESOLVED_INTERVAL);
    }

    public boolean isChangefeedIncludeUpdated() {
        return this.config.getBoolean(CHANGEFEED_INCLUDE_UPDATED);
    }

    public boolean isChangefeedIncludeDiff() {
        return this.config.getBoolean(CHANGEFEED_INCLUDE_DIFF);
    }

    public String getChangefeedEnrichedProperties() {
        return this.config.getString(CHANGEFEED_ENRICHED_PROPERTIES);
    }

    public String getChangefeedCursor() {
        return this.config.getString(CHANGEFEED_CURSOR);
    }

    public int getChangefeedBatchSize() {
        return this.config.getInteger(CHANGEFEED_BATCH_SIZE);
    }

    public long getChangefeedPollIntervalMs() {
        return this.config.getLong(CHANGEFEED_POLL_INTERVAL);
    }

    public String getChangefeedSinkType() {
        return this.config.getString(CHANGEFEED_SINK_TYPE);
    }

    public String getChangefeedSinkUri() {
        return this.config.getString(CHANGEFEED_SINK_URI);
    }

    public String getChangefeedSinkTopicPrefix() {
        return this.config.getString(CHANGEFEED_SINK_TOPIC_PREFIX);
    }

    public String getChangefeedSinkOptions() {
        return this.config.getString(CHANGEFEED_SINK_OPTIONS);
    }

    public long getConnectionTimeoutMs() {
        return this.config.getLong(CONNECTION_TIMEOUT_MS);
    }

    public long getConnectionRetryDelayMs() {
        return this.config.getLong(CONNECTION_RETRY_DELAY_MS);
    }

    public int getConnectionMaxRetries() {
        return this.config.getInteger(CONNECTION_MAX_RETRIES);
    }

    public String getSchemaName() {
        return this.config.getString(SCHEMA_NAME);
    }

    private static class SystemTablesPredicate
    implements Tables.TableFilter {
        protected static final List<String> SYSTEM_SCHEMAS = Arrays.asList("pg_catalog", "information_schema");
        protected static final List<String> SYSTEM_TABLES = List.of("spatial_ref_sys");
        protected static final String TEMP_TABLE_SCHEMA_PREFIX = "pg_temp";

        private SystemTablesPredicate() {
        }

        public boolean isIncluded(TableId t) {
            return t.schema() != null && !SYSTEM_SCHEMAS.contains(t.schema().toLowerCase()) && t.table() != null && !SYSTEM_TABLES.contains(t.table().toLowerCase()) && !t.schema().startsWith(TEMP_TABLE_SCHEMA_PREFIX);
        }
    }

    public static enum SnapshotMode implements EnumeratedValue
    {
        ALWAYS("always"),
        INITIAL("initial"),
        NEVER("never"),
        NO_DATA("no_data"),
        INITIAL_ONLY("initial_only"),
        WHEN_NEEDED("when_needed"),
        CONFIGURATION_BASED("configuration_based"),
        CUSTOM("custom");

        private final String value;

        private SnapshotMode(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static SnapshotMode parse(String value) {
            if (value == null) {
                return null;
            }
            if ("never".equalsIgnoreCase(value = value.trim())) {
                return NO_DATA;
            }
            for (SnapshotMode option : SnapshotMode.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }

        public static SnapshotMode parse(String value, String defaultValue) {
            SnapshotMode mode = SnapshotMode.parse(value);
            if (mode == null && defaultValue != null) {
                mode = SnapshotMode.parse(defaultValue);
            }
            return mode;
        }
    }

    public static enum SnapshotIsolationMode implements EnumeratedValue
    {
        SERIALIZABLE("serializable"),
        READ_COMMITTED("read_committed");

        private final String value;

        private SnapshotIsolationMode(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static SnapshotIsolationMode parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (SnapshotIsolationMode option : SnapshotIsolationMode.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }

        public static SnapshotIsolationMode parse(String value, String defaultValue) {
            SnapshotIsolationMode mode = SnapshotIsolationMode.parse(value);
            if (mode == null && defaultValue != null) {
                mode = SnapshotIsolationMode.parse(defaultValue);
            }
            return mode;
        }
    }

    public static enum SnapshotLockingMode implements EnumeratedValue
    {
        SHARED("shared"),
        NONE("none"),
        CUSTOM("custom");

        private final String value;

        private SnapshotLockingMode(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static SnapshotLockingMode parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (SnapshotLockingMode option : SnapshotLockingMode.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }

        public static SnapshotLockingMode parse(String value, String defaultValue) {
            SnapshotLockingMode mode = SnapshotLockingMode.parse(value);
            if (mode == null && defaultValue != null) {
                mode = SnapshotLockingMode.parse(defaultValue);
            }
            return mode;
        }
    }

    public static enum SecureConnectionMode implements EnumeratedValue
    {
        DISABLED("disable"),
        ALLOW("allow"),
        PREFER("prefer"),
        REQUIRED("require"),
        VERIFY_CA("verify-ca"),
        VERIFY_FULL("verify-full");

        private final String value;

        private SecureConnectionMode(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static SecureConnectionMode parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (SecureConnectionMode option : SecureConnectionMode.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }

        public static SecureConnectionMode parse(String value, String defaultValue) {
            SecureConnectionMode mode = SecureConnectionMode.parse(value);
            if (mode == null && defaultValue != null) {
                mode = SecureConnectionMode.parse(defaultValue);
            }
            return mode;
        }
    }
}

