/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.binlog.metrics;

import com.github.shyiko.mysql.binlog.BinaryLogClient;
import com.github.shyiko.mysql.binlog.jmx.BinaryLogClientStatistics;
import io.debezium.connector.base.ChangeEventQueueMetrics;
import io.debezium.connector.binlog.BinlogDatabaseSchema;
import io.debezium.connector.binlog.BinlogTaskContext;
import io.debezium.connector.binlog.metrics.BinlogStreamingChangeEventSourceMetricsMXBean;
import io.debezium.pipeline.metrics.CapturedTablesSupplier;
import io.debezium.pipeline.metrics.DefaultStreamingChangeEventSourceMetrics;
import io.debezium.pipeline.source.spi.EventMetadataProvider;
import io.debezium.pipeline.spi.Partition;
import io.debezium.util.Collect;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public class BinlogStreamingChangeEventSourceMetrics<T extends BinlogDatabaseSchema, P extends Partition>
extends DefaultStreamingChangeEventSourceMetrics<P>
implements BinlogStreamingChangeEventSourceMetricsMXBean {
    private final BinaryLogClient client;
    private final BinaryLogClientStatistics stats;
    private final AtomicLong numberOfCommittedTransactions = new AtomicLong();
    private final AtomicLong numberOfRolledBackTransactions = new AtomicLong();
    private final AtomicLong numberOfNotWellFormedTransactions = new AtomicLong();
    private final AtomicLong numberOfLargeTransactions = new AtomicLong();
    private final AtomicBoolean isGtidModeEnabled = new AtomicBoolean(false);
    private final AtomicLong milliSecondsBehindMaster = new AtomicLong();
    private final AtomicReference<String> lastTransactionId = new AtomicReference();

    public BinlogStreamingChangeEventSourceMetrics(BinlogTaskContext<T> taskContext, ChangeEventQueueMetrics changeEventQueueMetrics, EventMetadataProvider eventMetadataProvider, CapturedTablesSupplier capturedTablesSupplier, BinaryLogClient client) {
        super(taskContext, changeEventQueueMetrics, eventMetadataProvider, capturedTablesSupplier);
        this.client = client;
        this.stats = new BinaryLogClientStatistics(client);
        this.milliSecondsBehindMaster.set(-1L);
    }

    public boolean isConnected() {
        return this.client.isConnected();
    }

    @Override
    public String getBinlogFilename() {
        return this.client.getBinlogFilename();
    }

    @Override
    public long getBinlogPosition() {
        return this.client.getBinlogPosition();
    }

    @Override
    public String getGtidSet() {
        return this.client.getGtidSet();
    }

    @Override
    public boolean getIsGtidModeEnabled() {
        return this.isGtidModeEnabled.get();
    }

    public String getLastEvent() {
        return this.stats.getLastEvent();
    }

    public long getMilliSecondsSinceLastEvent() {
        return this.stats.getSecondsSinceLastEvent() * 1000L;
    }

    public long getTotalNumberOfEventsSeen() {
        return this.stats.getTotalNumberOfEventsSeen();
    }

    @Override
    public long getNumberOfSkippedEvents() {
        return this.stats.getNumberOfSkippedEvents();
    }

    @Override
    public long getNumberOfDisconnects() {
        return this.stats.getNumberOfDisconnects();
    }

    public void reset() {
        this.stats.reset();
        this.numberOfCommittedTransactions.set(0L);
        this.numberOfRolledBackTransactions.set(0L);
        this.numberOfNotWellFormedTransactions.set(0L);
        this.numberOfLargeTransactions.set(0L);
        this.lastTransactionId.set(null);
        this.isGtidModeEnabled.set(false);
    }

    @Override
    public long getNumberOfCommittedTransactions() {
        return this.numberOfCommittedTransactions.get();
    }

    @Override
    public long getNumberOfRolledBackTransactions() {
        return this.numberOfRolledBackTransactions.get();
    }

    @Override
    public long getNumberOfNotWellFormedTransactions() {
        return this.numberOfNotWellFormedTransactions.get();
    }

    @Override
    public long getNumberOfLargeTransactions() {
        return this.numberOfLargeTransactions.get();
    }

    public long getMilliSecondsBehindSource() {
        return this.milliSecondsBehindMaster.get();
    }

    public Map<String, String> getSourceEventPosition() {
        return Collect.hashMapOf((Object)"filename", (Object)this.getBinlogFilename(), (Object)"position", (Object)Long.toString(this.getBinlogPosition()), (Object)"gtid", (Object)this.getGtidSet());
    }

    public String getLastTransactionId() {
        return this.lastTransactionId.get();
    }

    public void onCommittedTransaction() {
        this.numberOfCommittedTransactions.incrementAndGet();
    }

    public void onRolledBackTransaction() {
        this.numberOfRolledBackTransactions.incrementAndGet();
    }

    public void onNotWellFormedTransaction() {
        this.numberOfNotWellFormedTransactions.incrementAndGet();
    }

    public void onLargeTransaction() {
        this.numberOfLargeTransactions.incrementAndGet();
    }

    public void onGtidChange(String gtid) {
        this.lastTransactionId.set(gtid);
    }

    public void setIsGtidModeEnabled(boolean enabled) {
        this.isGtidModeEnabled.set(enabled);
    }

    public void setMilliSecondsBehindSource(long value) {
        this.milliSecondsBehindMaster.set(value);
    }
}

