/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.binlog;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class BinlogGeometry {
    private static final int WKB_POINT_SIZE = 21;
    private static final byte[] WKB_EMPTY_GEOMETRYCOLLECTION = new byte[]{1, 7, 0, 0, 0, 0, 0, 0, 0};
    private final byte[] wkb;
    private final Integer srid;

    private BinlogGeometry(byte[] wkb, Integer srid) {
        this.wkb = wkb;
        this.srid = srid;
    }

    public static BinlogGeometry fromBytes(byte[] mysqlBytes) {
        ByteBuffer buf = ByteBuffer.wrap(mysqlBytes);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        Integer srid = buf.getInt();
        if (srid == 0) {
            srid = null;
        }
        byte[] wkb = new byte[buf.remaining()];
        buf.get(wkb);
        return new BinlogGeometry(wkb, srid);
    }

    public byte[] getWkb() {
        return this.wkb;
    }

    public Integer getSrid() {
        return this.srid;
    }

    public boolean isPoint() {
        return this.wkb.length == 21;
    }

    public static BinlogGeometry createEmpty() {
        return new BinlogGeometry(WKB_EMPTY_GEOMETRYCOLLECTION, null);
    }
}

