/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.binlog;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.connector.AbstractSourceInfo;
import io.debezium.connector.AbstractSourceInfoStructMaker;
import io.debezium.connector.binlog.BinlogSourceInfo;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;

public abstract class BinlogSourceInfoStructMaker<T extends BinlogSourceInfo>
extends AbstractSourceInfoStructMaker<T> {
    private Schema schema;

    public void init(String connector, String version, CommonConnectorConfig connectorConfig) {
        super.init(connector, version, connectorConfig);
        this.schema = this.commonSchemaBuilder().name(String.format("io.debezium.connector.%s.Source", this.getConnectorName())).field("table", Schema.OPTIONAL_STRING_SCHEMA).field("server_id", Schema.INT64_SCHEMA).field("gtid", Schema.OPTIONAL_STRING_SCHEMA).field("file", Schema.STRING_SCHEMA).field("pos", Schema.INT64_SCHEMA).field("row", Schema.INT32_SCHEMA).field("thread", Schema.OPTIONAL_INT64_SCHEMA).field("query", Schema.OPTIONAL_STRING_SCHEMA).build();
    }

    public Schema schema() {
        return this.schema;
    }

    public Struct struct(T sourceInfo) {
        Struct result = this.commonStruct((AbstractSourceInfo)sourceInfo);
        result.put("server_id", (Object)((BinlogSourceInfo)((Object)sourceInfo)).getServerId());
        if (((BinlogSourceInfo)((Object)sourceInfo)).getCurrentGtid() != null) {
            result.put("gtid", (Object)((BinlogSourceInfo)((Object)sourceInfo)).getCurrentGtid());
        }
        result.put("file", (Object)((BinlogSourceInfo)((Object)sourceInfo)).getCurrentBinlogFilename());
        result.put("pos", (Object)((BinlogSourceInfo)((Object)sourceInfo)).getCurrentBinlogPosition());
        result.put("row", (Object)((BinlogSourceInfo)((Object)sourceInfo)).getCurrentRowNumber());
        if (((BinlogSourceInfo)((Object)sourceInfo)).getThreadId() >= 0L) {
            result.put("thread", (Object)((BinlogSourceInfo)((Object)sourceInfo)).getThreadId());
        }
        if (((BinlogSourceInfo)((Object)sourceInfo)).table() != null) {
            result.put("table", (Object)((BinlogSourceInfo)((Object)sourceInfo)).table());
        }
        if (((BinlogSourceInfo)((Object)sourceInfo)).getQuery() != null) {
            result.put("query", (Object)((BinlogSourceInfo)((Object)sourceInfo)).getQuery());
        }
        return result;
    }

    protected abstract String getConnectorName();
}

