/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.binlog;

import io.debezium.DebeziumException;
import io.debezium.annotation.Immutable;
import io.debezium.config.Configuration;
import io.debezium.connector.binlog.BinlogConnectorConfig;
import io.debezium.connector.binlog.jdbc.BinlogConnectorConnection;
import io.debezium.connector.common.RelationalBaseSourceConnector;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.relational.RelationalTableFilters;
import io.debezium.relational.TableId;
import io.debezium.util.Threads;
import java.sql.SQLException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.ConfigValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BinlogConnector<T extends BinlogConnectorConfig>
extends RelationalBaseSourceConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(BinlogConnector.class);
    @Immutable
    private Map<String, String> properties;

    public void start(Map<String, String> props) {
        this.properties = Collections.unmodifiableMap(new HashMap<String, String>(props));
    }

    public void stop() {
    }

    public List<Map<String, String>> taskConfigs(int maxTasks) {
        if (maxTasks > 1) {
            throw new IllegalArgumentException("Only a single connector task may be started");
        }
        return Collections.singletonList(this.properties);
    }

    protected void validateConnection(Map<String, ConfigValue> configValues, Configuration config) {
        ConfigValue hostnameValue = configValues.get(RelationalDatabaseConnectorConfig.HOSTNAME.name());
        T connectorConfig = this.createConnectorConfig(config);
        Duration timeout = connectorConfig.getConnectionValidationTimeout();
        try {
            Threads.runWithTimeout(((Object)((Object)this)).getClass(), () -> {
                try (BinlogConnectorConnection connection = this.createConnection(config, connectorConfig);){
                    try {
                        connection.connect();
                        connection.execute(new String[]{"SELECT version()"});
                        LOGGER.info("Successfully tested connection for {} with user '{}'", (Object)connection.connectionString(), (Object)connection.connectionConfig().username());
                    }
                    catch (SQLException e) {
                        LOGGER.error("Failed testing connection for {} with user '{}'", new Object[]{connection.connectionString(), connection.connectionConfig().username(), e});
                        hostnameValue.addErrorMessage("Unable to connect: " + e.getMessage());
                    }
                }
                catch (SQLException e) {
                    LOGGER.error("Unexpected error shutting down the database connection", (Throwable)e);
                }
            }, (Duration)timeout, (String)connectorConfig.getLogicalName(), (String)"connection-validation");
        }
        catch (TimeoutException e) {
            hostnameValue.addErrorMessage("Connection validation timed out after " + timeout.toMillis() + " ms");
        }
        catch (Exception e) {
            hostnameValue.addErrorMessage("Error during connection validation: " + e.getMessage());
        }
    }

    public List<TableId> getMatchingCollections(Configuration config) {
        ArrayList arrayList;
        block9: {
            T connectorConfig = this.createConnectorConfig(config);
            BinlogConnectorConnection connection = this.createConnection(config, connectorConfig);
            try {
                ArrayList tables = new ArrayList();
                List<String> databaseNames = connection.availableDatabases();
                RelationalTableFilters tableFilter = connectorConfig.getTableFilters();
                for (String databaseName : databaseNames) {
                    if (!tableFilter.databaseFilter().test(databaseName)) continue;
                    tables.addAll(connection.readTableNames(databaseName, null, null, new String[]{"TABLE"}).stream().filter(tableId -> tableFilter.dataCollectionFilter().isIncluded(tableId)).collect(Collectors.toList()));
                }
                arrayList = tables;
                if (connection == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new DebeziumException((Throwable)e);
                }
            }
            connection.close();
        }
        return arrayList;
    }

    protected abstract BinlogConnectorConnection createConnection(Configuration var1, T var2);

    protected abstract T createConnectorConfig(Configuration var1);
}

