/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.checkstyle;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import java.util.HashSet;

public class IllegalImport
extends AbstractCheck {
    private final HashSet<String> notAllowedImports = new HashSet();
    private String message = "";

    public void setIllegalClassnames(String[] importStatements) {
        for (String impo : importStatements) {
            this.notAllowedImports.add(impo);
        }
    }

    public void setMessage(String message) {
        if (message != null) {
            this.message = message;
        }
    }

    public int[] getDefaultTokens() {
        return new int[]{30, 152};
    }

    public int[] getAcceptableTokens() {
        int[] defaultTokens = this.getDefaultTokens();
        int[] copy = new int[defaultTokens.length];
        System.arraycopy(defaultTokens, 0, copy, 0, defaultTokens.length);
        return copy;
    }

    public int[] getRequiredTokens() {
        return CommonUtil.EMPTY_INT_ARRAY;
    }

    public void visitToken(DetailAST aAST) {
        FullIdent imp = aAST.getType() == 30 ? FullIdent.createFullIdentBelow((DetailAST)aAST) : FullIdent.createFullIdent((DetailAST)aAST.getFirstChild().getNextSibling());
        String text = imp.getText();
        if (this.isIllegalImport(text)) {
            String message = this.buildError(text);
            this.log(aAST.getLineNo(), aAST.getColumnNo(), message, new Object[]{text});
        }
    }

    private String buildError(String importStatement) {
        return "Import statement violating a checkstyle rule: " + importStatement + ". " + this.message;
    }

    private boolean isIllegalImport(String importString) {
        return this.notAllowedImports.contains(importString);
    }
}

