/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.engine;

import io.debezium.DebeziumException;
import io.debezium.common.annotation.Incubating;
import io.debezium.engine.ChangeEvent;
import io.debezium.engine.RecordChangeEvent;
import io.debezium.engine.format.ChangeEventFormat;
import io.debezium.engine.format.KeyValueChangeEventFormat;
import io.debezium.engine.format.KeyValueHeaderChangeEventFormat;
import io.debezium.engine.format.SerializationFormat;
import io.debezium.engine.spi.OffsetCommitPolicy;
import java.io.Closeable;
import java.time.Clock;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import org.slf4j.LoggerFactory;

public interface DebeziumEngine<R>
extends Runnable,
Closeable {
    public static final String OFFSET_FLUSH_INTERVAL_MS_PROP = "offset.flush.interval.ms";

    @Incubating
    default public Signaler getSignaler() {
        throw new UnsupportedOperationException("Signaling is not supported by this engine");
    }

    public static <T> Builder<ChangeEvent<T, T>> create(Class<? extends SerializationFormat<T>> format) {
        return DebeziumEngine.create(format, format);
    }

    public static <K, V> Builder<ChangeEvent<K, V>> create(Class<? extends SerializationFormat<K>> keyFormat, Class<? extends SerializationFormat<V>> valueFormat) {
        return DebeziumEngine.create(KeyValueChangeEventFormat.of(keyFormat, valueFormat));
    }

    public static <K, V, H> Builder<ChangeEvent<K, V>> create(Class<? extends SerializationFormat<K>> keyFormat, Class<? extends SerializationFormat<V>> valueFormat, Class<? extends SerializationFormat<H>> headerFormat) {
        return DebeziumEngine.create(KeyValueHeaderChangeEventFormat.of(keyFormat, valueFormat, headerFormat));
    }

    public static <K, V, H> Builder<ChangeEvent<K, V>> create(Class<? extends SerializationFormat<K>> keyFormat, Class<? extends SerializationFormat<V>> valueFormat, Class<? extends SerializationFormat<H>> headerFormat, String builderFactory) {
        return DebeziumEngine.create(KeyValueHeaderChangeEventFormat.of(keyFormat, valueFormat, headerFormat), builderFactory);
    }

    public static <S, T, K extends SerializationFormat<S>, V extends SerializationFormat<T>> Builder<ChangeEvent<S, T>> create(KeyValueChangeEventFormat<K, V> format) {
        BuilderFactory builder = DebeziumEngine.determineBuilderFactory();
        return builder.builder(format);
    }

    public static <S, T, U, K extends SerializationFormat<S>, V extends SerializationFormat<T>, H extends SerializationFormat<U>> Builder<ChangeEvent<S, T>> create(KeyValueHeaderChangeEventFormat<K, V, H> format) {
        BuilderFactory builder = DebeziumEngine.determineBuilderFactory();
        return builder.builder(format);
    }

    public static <S, T, U, K extends SerializationFormat<S>, V extends SerializationFormat<T>, H extends SerializationFormat<U>> Builder<ChangeEvent<S, T>> create(KeyValueHeaderChangeEventFormat<K, V, H> format, String builderFactory) {
        BuilderFactory builder = DebeziumEngine.determineBuilderFactory(builderFactory);
        return builder.builder(format);
    }

    public static <T, V extends SerializationFormat<T>> Builder<RecordChangeEvent<T>> create(ChangeEventFormat<V> format) {
        BuilderFactory builder = DebeziumEngine.determineBuilderFactory();
        return builder.builder(format);
    }

    private static BuilderFactory determineBuilderFactory() {
        ServiceLoader<BuilderFactory> loader = ServiceLoader.load(BuilderFactory.class);
        Iterator<BuilderFactory> iterator = loader.iterator();
        if (!iterator.hasNext()) {
            throw new DebeziumException("No implementation of Debezium engine builder was found");
        }
        BuilderFactory builder = iterator.next();
        if (iterator.hasNext()) {
            LoggerFactory.getLogger(Builder.class).warn("More than one Debezium engine builder implementation was found, using {} (in Debezium 2.6 you can ignore this warning)", builder.getClass());
        }
        return builder;
    }

    private static BuilderFactory determineBuilderFactory(String builderFactory) {
        if (builderFactory == null || builderFactory.isBlank()) {
            return DebeziumEngine.determineBuilderFactory();
        }
        ServiceLoader<BuilderFactory> loader = ServiceLoader.load(BuilderFactory.class);
        Iterator<BuilderFactory> iterator = loader.iterator();
        if (!iterator.hasNext()) {
            throw new DebeziumException("No implementation of Debezium engine builder was found");
        }
        while (iterator.hasNext()) {
            BuilderFactory builder = iterator.next();
            if (!builder.getClass().getName().equalsIgnoreCase(builderFactory)) continue;
            return builder;
        }
        throw new DebeziumException(String.format("No builder factory '%s' found.", builderFactory));
    }

    public static interface Builder<R> {
        public Builder<R> notifying(Consumer<R> var1);

        public Builder<R> notifying(ChangeConsumer<R> var1);

        public Builder<R> using(Properties var1);

        public Builder<R> using(ClassLoader var1);

        public Builder<R> using(Clock var1);

        public Builder<R> using(CompletionCallback var1);

        public Builder<R> using(ConnectorCallback var1);

        public Builder<R> using(OffsetCommitPolicy var1);

        public DebeziumEngine<R> build();
    }

    public static interface BuilderFactory {
        public <T, V extends SerializationFormat<T>> Builder<RecordChangeEvent<T>> builder(ChangeEventFormat<V> var1);

        public <S, T, K extends SerializationFormat<S>, V extends SerializationFormat<T>> Builder<ChangeEvent<S, T>> builder(KeyValueChangeEventFormat<K, V> var1);

        default public <S, T, U, K extends SerializationFormat<S>, V extends SerializationFormat<T>, H extends SerializationFormat<U>> Builder<ChangeEvent<S, T>> builder(KeyValueHeaderChangeEventFormat<K, V, H> format) {
            throw new UnsupportedOperationException("Method must be implemented in order to support headers");
        }
    }

    @Incubating
    public static interface Signaler {
        public void signal(Signal var1);
    }

    @Incubating
    public record Signal(String id, String type, String data, Map<String, Object> additionalData) {
    }

    public static interface ChangeConsumer<R> {
        public void handleBatch(List<R> var1, RecordCommitter<R> var2) throws InterruptedException;

        default public boolean supportsTombstoneEvents() {
            return true;
        }
    }

    public static interface Offsets {
        public void set(String var1, Object var2);
    }

    public static interface RecordCommitter<R> {
        public void markProcessed(R var1) throws InterruptedException;

        public void markBatchFinished() throws InterruptedException;

        public void markProcessed(R var1, Offsets var2) throws InterruptedException;

        public Offsets buildOffsets();
    }

    public static interface ConnectorCallback {
        default public void connectorStarted() {
        }

        default public void connectorStopped() {
        }

        default public void taskStarted() {
        }

        default public void taskStopped() {
        }
    }

    public static interface CompletionCallback {
        public void handle(boolean var1, String var2, Throwable var3);
    }
}

