/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.spi.topic;

import io.debezium.common.annotation.Incubating;
import io.debezium.spi.schema.DataCollectionId;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Incubating
public interface TopicNamingStrategy<I extends DataCollectionId> {
    public static final Logger LOGGER = LoggerFactory.getLogger(TopicNamingStrategy.class);
    public static final String REPLACEMENT_CHAR = "_";

    public void configure(Properties var1);

    public String dataChangeTopic(I var1);

    public String schemaChangeTopic();

    public String heartbeatTopic();

    public String transactionTopic();

    default public String sanitizedTopicName(String topicName) {
        StringBuilder sanitizedNameBuilder = new StringBuilder(topicName.length());
        boolean changed = false;
        for (int i = 0; i < topicName.length(); ++i) {
            char c = topicName.charAt(i);
            if (c == '.' || c == '_' || c == '-' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9') {
                sanitizedNameBuilder.append(c);
                continue;
            }
            sanitizedNameBuilder.append(REPLACEMENT_CHAR);
            changed = true;
        }
        if (changed) {
            String sanitizedName = sanitizedNameBuilder.toString();
            LOGGER.warn("Topic '{}' name isn't a valid topic name, replacing it with '{}'.", (Object)topicName, (Object)sanitizedName);
            return sanitizedName;
        }
        return topicName;
    }
}

