/*
 * Decompiled with CFR 0.152.
 */
package io.data2viz.viz;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Canvas;
import android.view.MotionEvent;
import android.view.View;
import io.data2viz.geom.Size;
import io.data2viz.geom.SizeKt;
import io.data2viz.timer.Timer;
import io.data2viz.viz.AndroidCanvasRenderer;
import io.data2viz.viz.AndroidCanvasRendererKt;
import io.data2viz.viz.Resizable;
import io.data2viz.viz.ResizableSupport;
import io.data2viz.viz.Viz;
import io.data2viz.viz.VizContainer;
import io.data2viz.viz.VizTouchListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001d\u0010+\u001a\u00020,2\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020,0.H\u0096\u0001J!\u0010/\u001a\u00020\u000b2\u0017\u00100\u001a\u0013\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020,0.\u00a2\u0006\u0002\b1H\u0016J\u0010\u00102\u001a\u00020,2\u0006\u00103\u001a\u000204H\u0014J(\u00105\u001a\u00020,2\u0006\u00106\u001a\u00020\u00112\u0006\u00107\u001a\u00020\u00112\u0006\u00108\u001a\u00020\u00112\u0006\u00109\u001a\u00020\u0011H\u0014J\u0012\u0010:\u001a\u00020;2\b\u0010<\u001a\u0004\u0018\u00010=H\u0017R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u000f\"\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001c\u001a\u00020\u001d8V@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u000e\u0010#\u001a\u00020$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010'\u001a\b\u0012\u0004\u0012\u00020\u000b0(8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*\u00a8\u0006>"}, d2={"Lio/data2viz/viz/VizContainerView;", "Landroid/view/View;", "Lio/data2viz/viz/VizContainer;", "Lio/data2viz/viz/Resizable;", "context", "Landroid/content/Context;", "resizableSupport", "Lio/data2viz/viz/ResizableSupport;", "(Landroid/content/Context;Lio/data2viz/viz/ResizableSupport;)V", "allViz", "", "Lio/data2viz/viz/Viz;", "density", "", "getDensity", "()D", "drawCount", "", "getDrawCount", "()I", "setDrawCount", "(I)V", "fps", "getFps", "setFps", "(D)V", "renderers", "Lio/data2viz/viz/AndroidCanvasRenderer;", "value", "Lio/data2viz/geom/Size;", "size", "getSize", "()Lio/data2viz/geom/Size;", "setSize", "(Lio/data2viz/geom/Size;)V", "startTime", "", "timers", "Lio/data2viz/timer/Timer;", "vizList", "", "getVizList", "()Ljava/util/List;", "addResizeListener", "", "resizeListener", "Lkotlin/Function1;", "newViz", "init", "Lkotlin/ExtensionFunctionType;", "onDraw", "canvas", "Landroid/graphics/Canvas;", "onSizeChanged", "w", "h", "oldw", "oldh", "onTouchEvent", "", "event", "Landroid/view/MotionEvent;", "d2v-viz_release"})
@SuppressLint(value={"ViewConstructor"})
public class VizContainerView
extends View
implements VizContainer,
Resizable {
    @NotNull
    private final ResizableSupport resizableSupport;
    @NotNull
    private final List<Viz> allViz;
    @NotNull
    private final List<AndroidCanvasRenderer> renderers;
    private final double density;
    @NotNull
    private Size size;
    @NotNull
    private final List<Timer> timers;
    private int drawCount;
    private long startTime;
    private double fps;

    public VizContainerView(@NotNull Context context, @NotNull ResizableSupport resizableSupport) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)resizableSupport, (String)"resizableSupport");
        super(context);
        this.resizableSupport = resizableSupport;
        boolean bl = false;
        this.allViz = new ArrayList();
        bl = false;
        this.renderers = new ArrayList();
        this.density = context.getResources().getDisplayMetrics().density;
        AndroidCanvasRendererKt.setDensity((float)this.getDensity());
        this.size = SizeKt.size((double)100.0, (double)100.0);
        bl = false;
        this.timers = new ArrayList();
        this.drawCount = -1;
        this.startTime = System.currentTimeMillis();
    }

    public /* synthetic */ VizContainerView(Context context, ResizableSupport resizableSupport, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            resizableSupport = new ResizableSupport();
        }
        this(context, resizableSupport);
    }

    @Override
    public void addResizeListener(@NotNull Function1<? super Size, Unit> resizeListener) {
        Intrinsics.checkNotNullParameter(resizeListener, (String)"resizeListener");
        this.resizableSupport.addResizeListener(resizeListener);
    }

    @Override
    @NotNull
    public List<Viz> getVizList() {
        return this.allViz;
    }

    @Override
    public double getDensity() {
        return this.density;
    }

    @Override
    @NotNull
    public Viz newViz(@NotNull Function1<? super Viz, Unit> init) {
        Intrinsics.checkNotNullParameter(init, (String)"init");
        Object object = new Viz(null, null, 3, null);
        boolean bl = false;
        boolean bl2 = false;
        Viz $this$newViz_u24lambda_u2d0 = object;
        boolean bl3 = false;
        $this$newViz_u24lambda_u2d0.setSize(SizeKt.size((double)this.getSize().getWidth(), (double)this.getSize().getHeight()));
        init.invoke((Object)$this$newViz_u24lambda_u2d0);
        Viz viz = object;
        object = this;
        Object object2 = ((VizContainerView)object).allViz;
        bl2 = false;
        object2.add(viz);
        object2 = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"context");
        AndroidCanvasRenderer renderer2 = new AndroidCanvasRenderer((Context)object2, viz, null, (Function0)new Function0<Unit>(this){
            final /* synthetic */ VizContainerView this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.this$0.invalidate();
            }
        }, 4, null);
        object2 = this;
        Collection collection = ((VizContainerView)object2).renderers;
        boolean bl4 = false;
        collection.add(renderer2);
        return viz;
    }

    @Override
    @NotNull
    public Size getSize() {
        return this.size;
    }

    @Override
    public void setSize(@NotNull Size value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.size = value;
        Iterable $this$forEach$iv = this.getVizList();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Viz viz = (Viz)element$iv;
            boolean bl = false;
            viz.setSize(value);
        }
        this.resizableSupport.notifyNewSize(value);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.setSize(SizeKt.size((double)((double)w / (double)AndroidCanvasRendererKt.getDensity()), (double)((double)h / (double)AndroidCanvasRendererKt.getDensity())));
    }

    protected void onDraw(@NotNull Canvas canvas) {
        int n;
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        VizContainerView vizContainerView = this;
        int n2 = vizContainerView.drawCount;
        vizContainerView.drawCount = n2 + 1;
        if (this.drawCount == 100) {
            long delta = System.currentTimeMillis() - this.startTime;
            this.fps = 100000.0 / (double)delta;
            this.startTime = System.currentTimeMillis();
            this.drawCount = -1;
        }
        if ((n = 0) <= (n2 = this.allViz.size() + -1)) {
            do {
                int i = n++;
                AndroidCanvasRenderer renderer2 = this.renderers.get(i);
                renderer2.setCanvas(canvas);
                renderer2.draw$d2v_viz_release();
            } while (n <= n2);
        }
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(@Nullable MotionEvent event) {
        boolean handled = super.onTouchEvent(event);
        if (!handled) {
            Iterable $this$forEach$iv = this.renderers;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AndroidCanvasRenderer renderer2 = (AndroidCanvasRenderer)element$iv;
                boolean bl = false;
                Iterable $this$forEach$iv2 = renderer2.getOnTouchListeners();
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    VizTouchListener it = (VizTouchListener)element$iv2;
                    boolean bl2 = false;
                    it.onTouchEvent(this, event);
                }
            }
        }
        handled = true;
        return handled;
    }

    public final int getDrawCount() {
        return this.drawCount;
    }

    public final void setDrawCount(int n) {
        this.drawCount = n;
    }

    public final double getFps() {
        return this.fps;
    }

    public final void setFps(double d) {
        this.fps = d;
    }
}

