/*
 * Decompiled with CFR 0.152.
 */
package io.data2viz.viz;

import io.data2viz.InternalAPI;
import io.data2viz.color.Color;
import io.data2viz.color.ColorOrGradient;
import io.data2viz.color.Gradient;
import io.data2viz.viz.HasFill;
import io.data2viz.viz.HasStroke;
import io.data2viz.viz.Node;
import io.data2viz.viz.SvgStringBuilder;
import io.data2viz.viz.VizToSVGKt;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@InternalAPI
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c1\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u001a\u0010\u0003\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007J\u0012\u0010\n\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"Lio/data2viz/viz/StylesBuilder;", "", "()V", "add", "", "Lio/data2viz/viz/SvgStringBuilder;", "key", "", "value", "", "addStylesFor", "node", "Lio/data2viz/viz/Node;", "d2v-viz_release"})
public final class StylesBuilder {
    @NotNull
    public static final StylesBuilder INSTANCE = new StylesBuilder();

    private StylesBuilder() {
    }

    public final void add(@NotNull SvgStringBuilder $this$add, @NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)$this$add, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        $this$add.getBuilder().append(key + ':' + value + ';');
    }

    public final void add(@NotNull SvgStringBuilder $this$add, @NotNull String key, @NotNull Number value) {
        Intrinsics.checkNotNullParameter((Object)$this$add, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        $this$add.getBuilder().append(key + ':' + value + ';');
    }

    public final void addStylesFor(@NotNull SvgStringBuilder $this$addStylesFor, @NotNull Node node) {
        block13: {
            String id;
            ColorOrGradient colorOrGradient;
            ColorOrGradient it;
            Intrinsics.checkNotNullParameter((Object)$this$addStylesFor, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            if (node instanceof HasFill) {
                ColorOrGradient colorOrGradient2 = node.getFill();
                if (colorOrGradient2 != null) {
                    it = colorOrGradient2;
                    boolean bl = false;
                    colorOrGradient = it;
                    if (colorOrGradient instanceof Gradient) {
                        id = "grad" + ($this$addStylesFor.getGradients().size() + 1);
                        ((Collection)$this$addStylesFor.getGradients()).add(VizToSVGKt.gradientRendererOf((Gradient)it, id));
                        INSTANCE.add($this$addStylesFor, "fill", "url('#" + id + "')");
                    } else if (colorOrGradient instanceof Color) {
                        INSTANCE.add($this$addStylesFor, "fill", ((Color)it).getRgba());
                    } else {
                        throw new IllegalStateException("".toString());
                    }
                }
            }
            if (!(node instanceof HasStroke)) break block13;
            ColorOrGradient colorOrGradient3 = node.getStrokeColor();
            if (colorOrGradient3 != null) {
                it = colorOrGradient3;
                boolean bl = false;
                colorOrGradient = it;
                if (colorOrGradient instanceof Gradient) {
                    id = "grad" + ($this$addStylesFor.getGradients().size() + 1);
                    ((Collection)$this$addStylesFor.getGradients()).add(VizToSVGKt.gradientRendererOf((Gradient)it, id));
                    INSTANCE.add($this$addStylesFor, "stroke", "url('#" + id + "')");
                } else if (colorOrGradient instanceof Color) {
                    INSTANCE.add($this$addStylesFor, "stroke", ((Color)it).getRgba());
                } else {
                    throw new IllegalStateException("".toString());
                }
            }
            Double d = node.getStrokeWidth();
            if (d != null) {
                double it2 = ((Number)d).doubleValue();
                boolean bl = false;
                INSTANCE.add($this$addStylesFor, "stroke-width", it2);
            }
            double[] dArray = node.getDashedLine();
            if (dArray != null) {
                double[] it3 = dArray;
                boolean bl = false;
                INSTANCE.add($this$addStylesFor, "stroke-dasharray", ArraysKt.joinToString$default((double[])it3, (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
            }
        }
    }
}

