/*
 * Decompiled with CFR 0.152.
 */
package io.data2viz.viz;

import io.data2viz.color.Color;
import io.data2viz.color.ColorOrGradient;
import io.data2viz.color.Colors;
import io.data2viz.geom.Rect;
import io.data2viz.geom.Size;
import io.data2viz.viz.FontFamily;
import io.data2viz.viz.FontPosture;
import io.data2viz.viz.FontWeight;
import io.data2viz.viz.GroupNode;
import io.data2viz.viz.TextHAlign;
import io.data2viz.viz.TextNode;
import io.data2viz.viz.TextUtilsKt;
import io.data2viz.viz.TextVAlign;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001>B \u0012\u0019\b\u0002\u0010\u0002\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\b\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u00103\u001a\u000204J\u0006\u00105\u001a\u00020\bJ\b\u00106\u001a\u00020\u0004H\u0002J\u0006\u00107\u001a\u00020\u0004JO\u00108\u001a\u00020\u00042\u0006\u00109\u001a\u00020:2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00122\n\b\u0002\u0010;\u001a\u0004\u0018\u00010&2\n\b\u0002\u0010<\u001a\u0004\u0018\u00010&2\n\b\u0002\u0010-\u001a\u0004\u0018\u00010.2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010=R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00060\nR\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R%\u0010\u0002\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\b\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u000e\u0010%\u001a\u00020&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010(\u001a\u00020\u00122\u0006\u0010'\u001a\u00020\u0012@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\u0014\"\u0004\b*\u0010\u0016R\u0018\u0010+\u001a\f\u0012\b\u0012\u00060\nR\u00020\u00000,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010-\u001a\u00020.X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102\u00a8\u0006?"}, d2={"Lio/data2viz/viz/RichTextBuilder;", "", "init", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "(Lkotlin/jvm/functions/Function1;)V", "boundSize", "Lio/data2viz/geom/Size;", "currentLine", "Lio/data2viz/viz/RichTextBuilder$Line;", "fontFamily", "Lio/data2viz/viz/FontFamily;", "getFontFamily", "()Lio/data2viz/viz/FontFamily;", "setFontFamily", "(Lio/data2viz/viz/FontFamily;)V", "fontSize", "", "getFontSize", "()D", "setFontSize", "(D)V", "fontStyle", "Lio/data2viz/viz/FontPosture;", "getFontStyle", "()Lio/data2viz/viz/FontPosture;", "setFontStyle", "(Lio/data2viz/viz/FontPosture;)V", "fontWeight", "Lio/data2viz/viz/FontWeight;", "getFontWeight", "()Lio/data2viz/viz/FontWeight;", "setFontWeight", "(Lio/data2viz/viz/FontWeight;)V", "getInit$d2v_viz_release", "()Lkotlin/jvm/functions/Function1;", "initialized", "", "value", "lineSize", "getLineSize", "setLineSize", "lines", "", "textColor", "Lio/data2viz/color/Color;", "getTextColor", "()Lio/data2viz/color/Color;", "setTextColor", "(Lio/data2viz/color/Color;)V", "buildGroup", "Lio/data2viz/viz/GroupNode;", "computeSize", "lazyBuild", "newLine", "text", "textContent", "", "bold", "italic", "(Ljava/lang/String;Ljava/lang/Double;Ljava/lang/Boolean;Ljava/lang/Boolean;Lio/data2viz/color/Color;Lio/data2viz/viz/FontFamily;)V", "Line", "d2v-viz_release"})
public final class RichTextBuilder {
    @NotNull
    private final Function1<RichTextBuilder, Unit> init;
    private boolean initialized;
    @Nullable
    private Size boundSize;
    private double lineSize;
    private double fontSize;
    @NotNull
    private Color textColor;
    @NotNull
    private FontFamily fontFamily;
    @NotNull
    private FontWeight fontWeight;
    @NotNull
    private FontPosture fontStyle;
    @NotNull
    private Line currentLine;
    @NotNull
    private final List<Line> lines;

    public RichTextBuilder(@NotNull Function1<? super RichTextBuilder, Unit> init) {
        Intrinsics.checkNotNullParameter(init, (String)"init");
        this.init = init;
        this.lineSize = 1.15;
        this.fontSize = 12.0;
        this.textColor = Colors.Web.INSTANCE.getBlack();
        this.fontFamily = FontFamily.Companion.getSANS_SERIF();
        this.fontWeight = FontWeight.NORMAL;
        this.fontStyle = FontPosture.NORMAL;
        this.currentLine = new Line(this.lineSize);
        Object[] objectArray = new Line[]{this.currentLine};
        this.lines = CollectionsKt.mutableListOf((Object[])objectArray);
    }

    public /* synthetic */ RichTextBuilder(Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            function1 = 1.INSTANCE;
        }
        this((Function1<? super RichTextBuilder, Unit>)function1);
    }

    @NotNull
    public final Function1<RichTextBuilder, Unit> getInit$d2v_viz_release() {
        return this.init;
    }

    private final void lazyBuild() {
        if (!this.initialized) {
            this.init.invoke((Object)this);
            this.initialized = true;
        }
    }

    @NotNull
    public final GroupNode buildGroup() {
        GroupNode groupNode;
        this.lazyBuild();
        GroupNode $this$buildGroup_u24lambda_u2d2 = groupNode = new GroupNode();
        boolean bl = false;
        double lineHeights = 0.0;
        Iterable $this$forEach$iv = this.lines;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Line line = (Line)element$iv;
            boolean bl2 = false;
            double y = 0.0;
            y = lineHeights + line.getHeight() * 0.75;
            Iterable $this$forEach$iv2 = line.getNodes();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                TextNode it = (TextNode)element$iv2;
                boolean bl3 = false;
                it.setY(y);
                $this$buildGroup_u24lambda_u2d2.add(it);
            }
            lineHeights += line.getHeight();
        }
        return groupNode;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Size computeSize() {
        this.lazyBuild();
        if (this.boundSize == null) {
            void $this$fold$iv;
            Iterator iterator = ((Iterable)this.lines).iterator();
            if (!iterator.hasNext()) {
                throw new NoSuchElementException();
            }
            Object it = (Line)iterator.next();
            boolean bl = false;
            double d = ((Number)CollectionsKt.last(((Line)it).getStarts())).doubleValue();
            while (iterator.hasNext()) {
                Line it2 = (Line)iterator.next();
                $i$a$-maxOf-RichTextBuilder$computeSize$width$1 = false;
                double d2 = ((Number)CollectionsKt.last(it2.getStarts())).doubleValue();
                d = Math.max(d, d2);
            }
            double width = d;
            it = this.lines;
            double initial$iv = 0.0;
            boolean $i$f$fold = false;
            double accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                void line;
                Line line2 = (Line)element$iv;
                double acc = accumulator$iv;
                boolean bl2 = false;
                accumulator$iv = acc + line.getFontSize() * line.getLineSize();
            }
            double height = accumulator$iv;
            this.boundSize = new Size(width, height);
        }
        Size size = this.boundSize;
        Intrinsics.checkNotNull((Object)size);
        return size;
    }

    public final double getLineSize() {
        return this.lineSize;
    }

    public final void setLineSize(double value) {
        this.lineSize = value;
        this.currentLine.setLineSize(value);
    }

    public final double getFontSize() {
        return this.fontSize;
    }

    public final void setFontSize(double d) {
        this.fontSize = d;
    }

    @NotNull
    public final Color getTextColor() {
        return this.textColor;
    }

    public final void setTextColor(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"<set-?>");
        this.textColor = color;
    }

    @NotNull
    public final FontFamily getFontFamily() {
        return this.fontFamily;
    }

    public final void setFontFamily(@NotNull FontFamily fontFamily) {
        Intrinsics.checkNotNullParameter((Object)fontFamily, (String)"<set-?>");
        this.fontFamily = fontFamily;
    }

    @NotNull
    public final FontWeight getFontWeight() {
        return this.fontWeight;
    }

    public final void setFontWeight(@NotNull FontWeight fontWeight) {
        Intrinsics.checkNotNullParameter((Object)((Object)fontWeight), (String)"<set-?>");
        this.fontWeight = fontWeight;
    }

    @NotNull
    public final FontPosture getFontStyle() {
        return this.fontStyle;
    }

    public final void setFontStyle(@NotNull FontPosture fontPosture) {
        Intrinsics.checkNotNullParameter((Object)((Object)fontPosture), (String)"<set-?>");
        this.fontStyle = fontPosture;
    }

    public final void newLine() {
        this.currentLine = new Line(this.lineSize);
        this.lines.add(this.currentLine);
    }

    public final void text(@NotNull String textContent, @Nullable Double fontSize, @Nullable Boolean bold, @Nullable Boolean italic, @Nullable Color textColor, @Nullable FontFamily fontFamily) {
        FontPosture fontPosture;
        FontWeight fontWeight;
        Intrinsics.checkNotNullParameter((Object)textContent, (String)"textContent");
        TextNode textNode = new TextNode();
        textNode.setTextContent(textContent);
        Color color = textColor;
        textNode.setTextColor(color != null ? (ColorOrGradient)color : (ColorOrGradient)this.textColor);
        FontFamily fontFamily2 = fontFamily;
        if (fontFamily2 == null) {
            fontFamily2 = this.fontFamily;
        }
        textNode.setFontFamily(fontFamily2);
        textNode.setHAlign(TextHAlign.LEFT);
        textNode.setVAlign(TextVAlign.BASELINE);
        Double d = fontSize;
        textNode.setFontSize(d != null ? d : this.fontSize);
        Boolean bl = bold;
        if (bl == null) {
            fontWeight = this.fontWeight;
        } else if (Intrinsics.areEqual((Object)bl, (Object)true)) {
            fontWeight = FontWeight.BOLD;
        } else if (Intrinsics.areEqual((Object)bl, (Object)false)) {
            fontWeight = FontWeight.NORMAL;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        textNode.setFontWeight(fontWeight);
        bl = italic;
        if (bl == null) {
            fontPosture = this.fontStyle;
        } else if (Intrinsics.areEqual((Object)bl, (Object)true)) {
            fontPosture = FontPosture.ITALIC;
        } else if (Intrinsics.areEqual((Object)bl, (Object)false)) {
            fontPosture = FontPosture.NORMAL;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        textNode.setFontStyle(fontPosture);
        this.currentLine.add(textNode);
    }

    public static /* synthetic */ void text$default(RichTextBuilder richTextBuilder, String string, Double d, Boolean bl, Boolean bl2, Color color, FontFamily fontFamily, int n, Object object) {
        if ((n & 2) != 0) {
            d = null;
        }
        if ((n & 4) != 0) {
            bl = null;
        }
        if ((n & 8) != 0) {
            bl2 = null;
        }
        if ((n & 0x10) != 0) {
            color = null;
        }
        if ((n & 0x20) != 0) {
            fontFamily = null;
        }
        richTextBuilder.text(string, d, bl, bl2, color, fontFamily);
    }

    public RichTextBuilder() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u000b\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0010R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\b\"\u0004\b\f\u0010\rR \u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0012\u00a8\u0006\u001a"}, d2={"Lio/data2viz/viz/RichTextBuilder$Line;", "", "lineSize", "", "(Lio/data2viz/viz/RichTextBuilder;D)V", "_fontSize", "fontSize", "getFontSize", "()D", "height", "getHeight", "getLineSize", "setLineSize", "(D)V", "nodes", "", "Lio/data2viz/viz/TextNode;", "getNodes", "()Ljava/util/List;", "setNodes", "(Ljava/util/List;)V", "starts", "getStarts", "add", "", "textNode", "d2v-viz_release"})
    private final class Line {
        private double lineSize;
        @NotNull
        private List<TextNode> nodes;
        @NotNull
        private final List<Double> starts;
        private double _fontSize;

        public Line(double lineSize) {
            this.lineSize = lineSize;
            this.nodes = new ArrayList();
            Object[] objectArray = new Double[]{0.0};
            this.starts = CollectionsKt.mutableListOf((Object[])objectArray);
        }

        public final double getLineSize() {
            return this.lineSize;
        }

        public final void setLineSize(double d) {
            this.lineSize = d;
        }

        @NotNull
        public final List<TextNode> getNodes() {
            return this.nodes;
        }

        public final void setNodes(@NotNull List<TextNode> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.nodes = list;
        }

        @NotNull
        public final List<Double> getStarts() {
            return this.starts;
        }

        public final double getFontSize() {
            return this._fontSize;
        }

        public final double getHeight() {
            return this.getFontSize() * this.lineSize;
        }

        public final void add(@NotNull TextNode textNode) {
            Intrinsics.checkNotNullParameter((Object)textNode, (String)"textNode");
            this._fontSize = Math.max(this._fontSize, textNode.getFontSize());
            RichTextBuilder.this.boundSize = null;
            textNode.setX(((Number)CollectionsKt.last(this.starts)).doubleValue());
            this.nodes.add(textNode);
            Rect measureText = TextUtilsKt.measureText(textNode);
            this.starts.add(((Number)CollectionsKt.last(this.starts)).doubleValue() + measureText.getWidth());
        }
    }
}

