/*
 * Decompiled with CFR 0.152.
 */
package io.data2viz.viz;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import io.data2viz.color.ColorOrGradient;
import io.data2viz.geom.Arc;
import io.data2viz.geom.ArcTo;
import io.data2viz.geom.BezierCurveTo;
import io.data2viz.geom.ClosePath;
import io.data2viz.geom.LineTo;
import io.data2viz.geom.MoveTo;
import io.data2viz.geom.PathCommand;
import io.data2viz.geom.QuadraticCurveTo;
import io.data2viz.geom.RectCmd;
import io.data2viz.viz.AndroidCanvasRenderer;
import io.data2viz.viz.AndroidCanvasRendererKt;
import io.data2viz.viz.AndroidColorOrGradientRendererKt;
import io.data2viz.viz.AndroidLineRendererKt;
import io.data2viz.viz.PathNode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\u0010\u0004\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0010\u000b\n\u0000\u001a\u000e\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004\u001a\f\u0010\n\u001a\u00020\u0001*\u00020\u0004H\u0002\u001a\u0012\u0010\u000b\u001a\u00020\f*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\f\u0010\u0010\u001a\u00020\u0011*\u00020\u0012H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u0003\u001a\u00020\u0004*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"EPSILON_CIRCLE", "", "EPSILON_FLOAT", "radToDeg", "", "", "getRadToDeg", "(Ljava/lang/Number;)D", "angle", "alpha", "radToDegrees", "render", "", "Lio/data2viz/viz/PathNode;", "renderer", "Lio/data2viz/viz/AndroidCanvasRenderer;", "toSign", "", "", "d2v-viz_release"})
public final class AndroidPathRendererKt {
    private static final float EPSILON_FLOAT = 1.0E-4f;
    private static final float EPSILON_CIRCLE = 359.9999f;

    /*
     * WARNING - void declaration
     */
    public static final void render(@NotNull PathNode $this$render, @NotNull AndroidCanvasRenderer renderer2) {
        Intrinsics.checkNotNullParameter((Object)$this$render, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)renderer2, (String)"renderer");
        Canvas canvas = renderer2.getCanvas();
        Path path = new Path();
        RectF rect = new RectF();
        Iterable $this$forEachIndexed$iv = $this$render.getPath().getCommands();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void cmd;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            PathCommand pathCommand = (PathCommand)item$iv;
            int index = n;
            boolean bl = false;
            AndroidCanvasRenderer $this$render_u24lambda_u2d3_u24lambda_u2d2 = renderer2;
            boolean bl2 = false;
            void var16_18 = cmd;
            if (var16_18 instanceof MoveTo) {
                path.moveTo(AndroidCanvasRendererKt.getDp(cmd.getX()), AndroidCanvasRendererKt.getDp(cmd.getY()));
                continue;
            }
            if (var16_18 instanceof LineTo) {
                path.lineTo(AndroidCanvasRendererKt.getDp(cmd.getX()), AndroidCanvasRendererKt.getDp(cmd.getY()));
                continue;
            }
            if (var16_18 instanceof QuadraticCurveTo) {
                path.quadTo(AndroidCanvasRendererKt.getDp(((QuadraticCurveTo)cmd).getCpx()), AndroidCanvasRendererKt.getDp(((QuadraticCurveTo)cmd).getCpy()), AndroidCanvasRendererKt.getDp(cmd.getX()), AndroidCanvasRendererKt.getDp(cmd.getY()));
                continue;
            }
            if (var16_18 instanceof BezierCurveTo) {
                path.cubicTo(AndroidCanvasRendererKt.getDp(((BezierCurveTo)cmd).getCpx1()), AndroidCanvasRendererKt.getDp(((BezierCurveTo)cmd).getCpy1()), AndroidCanvasRendererKt.getDp(((BezierCurveTo)cmd).getCpx2()), AndroidCanvasRendererKt.getDp(((BezierCurveTo)cmd).getCpy2()), AndroidCanvasRendererKt.getDp(cmd.getX()), AndroidCanvasRendererKt.getDp(cmd.getY()));
                continue;
            }
            if (var16_18 instanceof ArcTo) {
                PathCommand last = AndroidPathRendererKt.render$last($this$render, index);
                AndroidPathRendererKt.render$arcTo(renderer2, path, rect, last.getX(), last.getY(), ((ArcTo)cmd).getFromX(), ((ArcTo)cmd).getFromY(), cmd.getX(), cmd.getY(), ((ArcTo)cmd).getRadius());
                continue;
            }
            if (var16_18 instanceof RectCmd) {
                path.addRect(AndroidCanvasRendererKt.getDp(cmd.getX()), AndroidCanvasRendererKt.getDp(cmd.getY()), AndroidCanvasRendererKt.getDp(cmd.getX() + ((RectCmd)cmd).getW()), AndroidCanvasRendererKt.getDp(cmd.getY() + ((RectCmd)cmd).getH()), Path.Direction.CW);
                continue;
            }
            if (var16_18 instanceof ClosePath) {
                path.close();
                continue;
            }
            if (var16_18 instanceof Arc) {
                double r = ((Arc)cmd).getRadius();
                rect.left = AndroidCanvasRendererKt.getDp(((Arc)cmd).getCenterX() - r);
                rect.top = AndroidCanvasRendererKt.getDp(((Arc)cmd).getCenterY() - r);
                rect.right = AndroidCanvasRendererKt.getDp(((Arc)cmd).getCenterX() + r);
                rect.bottom = AndroidCanvasRendererKt.getDp(((Arc)cmd).getCenterY() + r);
                float startAngle = AndroidPathRendererKt.radToDegrees(((Arc)cmd).getStartAngle());
                float sweepAngle = AndroidPathRendererKt.radToDegrees(((Arc)cmd).getEndAngle()) - startAngle;
                if (!((Arc)cmd).getCounterClockWise() && sweepAngle < -1.0E-4f) {
                    sweepAngle = sweepAngle % (float)360 + (float)360;
                }
                if (((Arc)cmd).getCounterClockWise() && sweepAngle > 1.0E-4f) {
                    sweepAngle = sweepAngle % (float)360 - (float)360;
                }
                if (Math.abs(sweepAngle) >= 359.9999f && Math.abs(sweepAngle % (float)360) <= 1.0E-4f) {
                    sweepAngle = 359.9999f * Math.signum(sweepAngle);
                }
                path.arcTo(rect, startAngle, sweepAngle);
                continue;
            }
            throw new IllegalStateException(("Unknown path command:: " + Reflection.getOrCreateKotlinClass(cmd.getClass())).toString());
        }
        ColorOrGradient colorOrGradient = $this$render.getFill();
        if (colorOrGradient != null) {
            ColorOrGradient it = colorOrGradient;
            boolean bl = false;
            AndroidCanvasRendererKt.getPaint().setStyle(Paint.Style.FILL);
            AndroidColorOrGradientRendererKt.updatePaint(it, AndroidCanvasRendererKt.getPaint(), renderer2);
            canvas.drawPath(path, AndroidCanvasRendererKt.getPaint());
        }
        if ($this$render.getStrokeColor() != null && $this$render.getStrokeWidth() != null) {
            AndroidCanvasRendererKt.getPaint().setStyle(Paint.Style.STROKE);
            AndroidLineRendererKt.setStrokeWidth($this$render.getStrokeWidth());
            ColorOrGradient colorOrGradient2 = $this$render.getStrokeColor();
            if (colorOrGradient2 != null) {
                AndroidColorOrGradientRendererKt.updatePaint(colorOrGradient2, AndroidCanvasRendererKt.getPaint(), renderer2);
            }
            canvas.drawPath(path, AndroidCanvasRendererKt.getPaint());
        }
    }

    public static final double getRadToDeg(@NotNull Number $this$radToDeg) {
        Intrinsics.checkNotNullParameter((Object)$this$radToDeg, (String)"<this>");
        return $this$radToDeg.doubleValue() * (double)180 / Math.PI;
    }

    public static final double angle(double alpha) {
        return alpha > Math.PI ? alpha - Math.PI * 2 : (alpha < -Math.PI ? Math.PI * 2 + alpha : alpha);
    }

    private static final int toSign(boolean $this$toSign) {
        return $this$toSign ? 1 : -1;
    }

    private static final float radToDegrees(double $this$radToDegrees) {
        return (float)Math.toDegrees($this$radToDegrees);
    }

    private static final PathCommand render$last(PathNode $this$render_u24last, int index) {
        if (!(index > 0)) {
            boolean bl = false;
            String string = "Index should be up to 0";
            throw new IllegalArgumentException(string.toString());
        }
        return (PathCommand)$this$render_u24last.getPath().getCommands().get(index - 1);
    }

    private static final void render$arcTo(AndroidCanvasRenderer $renderer, Path path, RectF rect, double lastX, double lastY, double cpX, double cpY, double x, double y, double r) {
        AndroidCanvasRenderer $this$render_u24arcTo_u24lambda_u2d1 = $renderer;
        boolean bl = false;
        double alpha1 = Math.atan2(lastY - cpY, lastX - cpX);
        double alpha2 = Math.atan2(y - cpY, x - cpX);
        double alpha = AndroidPathRendererKt.angle(alpha1 - alpha2);
        double d = r / Math.abs(Math.sin(alpha / (double)2));
        double cx = cpX + d * Math.cos(alpha1 - alpha / (double)2);
        double cy = cpY + d * Math.sin(alpha1 - alpha / (double)2);
        boolean clockwise = alpha > 0.0;
        float startAngle = (float)AndroidPathRendererKt.getRadToDeg(alpha1) + (float)AndroidPathRendererKt.toSign(clockwise) * 90.0f;
        float sweepAngle = clockwise ? (float)360 - (180.0f + (float)AndroidPathRendererKt.getRadToDeg(alpha)) % 360.0f : (-180.0f - (float)AndroidPathRendererKt.getRadToDeg(alpha)) % 360.0f;
        path.moveTo(AndroidCanvasRendererKt.getDp(lastX), AndroidCanvasRendererKt.getDp(lastY));
        rect.left = AndroidCanvasRendererKt.getDp(cx - r);
        rect.top = AndroidCanvasRendererKt.getDp(cy - r);
        rect.right = AndroidCanvasRendererKt.getDp(cx + r);
        rect.bottom = AndroidCanvasRendererKt.getDp(cy + r);
        path.arcTo(rect, startAngle, sweepAngle, false);
        path.lineTo(AndroidCanvasRendererKt.getDp(x), AndroidCanvasRendererKt.getDp(y));
    }
}

