/*
 * Decompiled with CFR 0.152.
 */
package io.data2viz.viz;

import android.graphics.Rect;
import android.os.Build;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.VelocityTracker;
import android.view.View;
import io.data2viz.geom.Point;
import io.data2viz.viz.AndroidActionEventHandle;
import io.data2viz.viz.AndroidCanvasRenderer;
import io.data2viz.viz.AndroidCanvasRendererKt;
import io.data2viz.viz.AndroidEventHandle;
import io.data2viz.viz.AndroidEventsKt;
import io.data2viz.viz.DetectClickVizTouchListener;
import io.data2viz.viz.DetectDoubleClickVizTouchListener;
import io.data2viz.viz.DetectInBoundsVizTouchListener;
import io.data2viz.viz.Disposable;
import io.data2viz.viz.EventType;
import io.data2viz.viz.ExperimentalKEvent;
import io.data2viz.viz.KEvent;
import io.data2viz.viz.KEventHandle;
import io.data2viz.viz.KEventListener;
import io.data2viz.viz.KPointer;
import io.data2viz.viz.KPointerEvent;
import io.data2viz.viz.KPointerEventImpl;
import io.data2viz.viz.KZoomEvent;
import io.data2viz.viz.MouseButtonPressed;
import io.data2viz.viz.PointerType;
import io.data2viz.viz.VizRenderer;
import io.data2viz.viz.VizTouchListener;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u0080\u0001\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a4\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0002\u001a$\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nH\u0002\u001a$\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nH\u0002\u001a,\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nH\u0002\u001a\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001d2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u001a\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001dH\u0001\u001a\f\u0010 \u001a\u00020\u000e*\u00020\u0010H\u0002\u001a$\u0010!\u001a\u00020\"\"\b\b\u0000\u0010#*\u00020$*\u00020%2\f\u0010&\u001a\b\u0012\u0004\u0012\u0002H#0'H\u0000\u001a\f\u0010(\u001a\u00020)*\u00020*H\u0002\u001a\f\u0010+\u001a\u00020,*\u00020*H\u0002\u001a\u0014\u0010-\u001a\u00020\u000b*\u00020*2\u0006\u0010\r\u001a\u00020\u000eH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0002\u001a\n \u0004*\u0004\u0018\u00010\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"epsilon", "", "vt", "Landroid/view/VelocityTracker;", "kotlin.jvm.PlatformType", "addSingleTouchAndroidEventHandle", "Lio/data2viz/viz/AndroidActionEventHandle;", "target", "", "listener", "Lkotlin/Function1;", "Lio/data2viz/viz/KPointerEvent;", "", "type", "Lio/data2viz/viz/EventType;", "action", "", "checkIsViewInBounds", "", "view", "Landroid/view/View;", "x", "", "y", "clickEventHandler", "doubleClickEventHandler", "enterLeaveEventHandler", "enter", "pointerEventsListener", "Lio/data2viz/viz/KEventListener;", "zoomEventsListener", "Lio/data2viz/viz/KZoomEvent;", "actionMaskToEventType", "addNativeEventListenerFromHandle", "Lio/data2viz/viz/Disposable;", "T", "Lio/data2viz/viz/KEvent;", "Lio/data2viz/viz/VizRenderer;", "handle", "Lio/data2viz/viz/KEventHandle;", "pointerType", "Lio/data2viz/viz/PointerType;", "Landroid/view/MotionEvent;", "pressedMouseButton", "Lio/data2viz/viz/MouseButtonPressed;", "toKPointerEvent", "d2v-viz_release"})
public final class AndroidEventsKt {
    private static final double epsilon = 0.001;
    private static final VelocityTracker vt = VelocityTracker.obtain();

    @NotNull
    public static final KEventListener<KPointerEvent> pointerEventsListener(@NotNull EventType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        if (!(type != EventType.Unknown)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return new KEventListener<KPointerEvent>(type){
            final /* synthetic */ EventType $type;
            {
                this.$type = $type;
            }

            @NotNull
            public Disposable addNativeListener(@NotNull Object target, @NotNull Function1<? super KPointerEvent, Unit> listener) {
                int n;
                Intrinsics.checkNotNullParameter((Object)target, (String)"target");
                Intrinsics.checkNotNullParameter(listener, (String)"listener");
                switch (pointerEventsListener.WhenMappings.$EnumSwitchMapping$0[this.$type.ordinal()]) {
                    case 1: {
                        n = 0;
                        break;
                    }
                    case 2: {
                        n = 1;
                        break;
                    }
                    case 3: {
                        n = 2;
                        break;
                    }
                    case 4: {
                        return AndroidEventsKt.access$enterLeaveEventHandler(true, target, listener);
                    }
                    case 5: {
                        return AndroidEventsKt.access$enterLeaveEventHandler(false, target, listener);
                    }
                    case 6: {
                        return AndroidEventsKt.access$clickEventHandler(target, listener);
                    }
                    case 7: {
                        return AndroidEventsKt.access$doubleClickEventHandler(target, listener);
                    }
                    case 8: {
                        n = 3;
                        break;
                    }
                    case 9: {
                        throw new IllegalStateException("Impossible".toString());
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                return AndroidEventsKt.access$addSingleTouchAndroidEventHandle(target, listener, this.$type, n);
            }
        };
    }

    private static final AndroidActionEventHandle enterLeaveEventHandler(boolean enter, Object target, Function1<? super KPointerEvent, Unit> listener) {
        AndroidActionEventHandle androidActionEventHandle;
        AndroidCanvasRenderer renderer2 = (AndroidCanvasRenderer)target;
        DetectInBoundsVizTouchListener handler2 = new DetectInBoundsVizTouchListener(enter, listener){
            final /* synthetic */ boolean $enter;
            final /* synthetic */ Function1<KPointerEvent, Unit> $listener;
            {
                this.$enter = $enter;
                this.$listener = $listener;
            }

            public void onBoundsChanged(@NotNull MotionEvent event, boolean oldInBoundsValue, boolean newInBoundsValue) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (this.$enter == newInBoundsValue) {
                    KPointerEvent kEvent = AndroidEventsKt.access$toKPointerEvent(event, this.$enter ? EventType.Enter : EventType.Leave);
                    this.$listener.invoke((Object)kEvent);
                }
            }
        };
        AndroidActionEventHandle it = androidActionEventHandle = new AndroidActionEventHandle(renderer2, 2, handler2);
        boolean bl = false;
        it.init();
        return androidActionEventHandle;
    }

    private static final AndroidActionEventHandle clickEventHandler(Object target, Function1<? super KPointerEvent, Unit> listener) {
        AndroidActionEventHandle androidActionEventHandle;
        AndroidActionEventHandle it = androidActionEventHandle = new AndroidActionEventHandle((AndroidCanvasRenderer)target, 1, new DetectClickVizTouchListener(listener){
            final /* synthetic */ Function1<KPointerEvent, Unit> $listener;
            {
                this.$listener = $listener;
            }

            public void onClick(@NotNull MotionEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                KPointerEvent kEvent = AndroidEventsKt.access$toKPointerEvent(event, EventType.Click);
                this.$listener.invoke((Object)kEvent);
            }
        });
        boolean bl = false;
        it.init();
        return androidActionEventHandle;
    }

    private static final AndroidActionEventHandle doubleClickEventHandler(Object target, Function1<? super KPointerEvent, Unit> listener) {
        AndroidActionEventHandle androidActionEventHandle;
        AndroidActionEventHandle it = androidActionEventHandle = new AndroidActionEventHandle((AndroidCanvasRenderer)target, 1, new DetectDoubleClickVizTouchListener(listener){
            final /* synthetic */ Function1<KPointerEvent, Unit> $listener;
            {
                this.$listener = $listener;
            }

            public void onDoubleClick(@NotNull MotionEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                KPointerEvent kevent = AndroidEventsKt.access$toKPointerEvent(event, EventType.DoubleClick);
                this.$listener.invoke((Object)kevent);
            }
        });
        boolean bl = false;
        it.init();
        return androidActionEventHandle;
    }

    @ExperimentalKEvent
    @NotNull
    public static final KEventListener<KZoomEvent> zoomEventsListener() {
        return new KEventListener<KZoomEvent>(){

            @NotNull
            public Disposable addNativeListener(@NotNull Object target, @NotNull Function1<? super KZoomEvent, Unit> listener) {
                AndroidEventHandle androidEventHandle;
                Intrinsics.checkNotNullParameter((Object)target, (String)"target");
                Intrinsics.checkNotNullParameter(listener, (String)"listener");
                AndroidCanvasRenderer androidCanvasRenderer = (AndroidCanvasRenderer)target;
                ScaleGestureDetector gestureDetector2 = new ScaleGestureDetector(androidCanvasRenderer.getContext(), new ScaleGestureDetector.OnScaleGestureListener(listener){
                    final /* synthetic */ Function1<KZoomEvent, Unit> $listener;
                    {
                        this.$listener = $listener;
                    }

                    public boolean onScaleBegin(@NotNull ScaleGestureDetector detector) {
                        Intrinsics.checkNotNullParameter((Object)detector, (String)"detector");
                        return true;
                    }

                    public void onScaleEnd(@NotNull ScaleGestureDetector detector) {
                        Intrinsics.checkNotNullParameter((Object)detector, (String)"detector");
                    }

                    public boolean onScale(@NotNull ScaleGestureDetector detector) {
                        Intrinsics.checkNotNullParameter((Object)detector, (String)"detector");
                        double scaleFactorX = 0.0;
                        double scaleFactorY = 0.0;
                        double minSpanX = 50.0;
                        double minSpanY = 50.0;
                        Point zoomStartPoint = new Point((double)detector.getFocusX(), (double)detector.getFocusY());
                        if ((double)Math.abs(detector.getCurrentSpanX()) > minSpanX) {
                            scaleFactorX = (double)(detector.getCurrentSpanX() / detector.getPreviousSpanX()) - 1.0;
                        }
                        if ((double)Math.abs(detector.getCurrentSpanY()) > minSpanY) {
                            scaleFactorY = (double)(detector.getCurrentSpanY() / detector.getPreviousSpanY()) - 1.0;
                        }
                        if (Math.abs(scaleFactorX) > AndroidEventsKt.access$getEpsilon$p() && Math.abs(scaleFactorY) > AndroidEventsKt.access$getEpsilon$p()) {
                            this.$listener.invoke((Object)new KZoomEvent(zoomStartPoint, scaleFactorX, scaleFactorY, null, 8, null));
                        }
                        return true;
                    }
                });
                VizTouchListener gestureDetectorVizTouchListener2 = new VizTouchListener(gestureDetector2){
                    final /* synthetic */ ScaleGestureDetector $gestureDetector;
                    {
                        this.$gestureDetector = $gestureDetector;
                    }

                    public boolean onTouchEvent(@NotNull View view, @Nullable MotionEvent event) {
                        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                        return this.$gestureDetector.onTouchEvent(event);
                    }
                };
                AndroidEventHandle it = androidEventHandle = new AndroidEventHandle(androidCanvasRenderer, gestureDetectorVizTouchListener2);
                boolean bl = false;
                it.init();
                return androidEventHandle;
            }
        };
    }

    private static final boolean checkIsViewInBounds(View view, float x, float y) {
        Rect boundsRect = new Rect();
        int[] locationOnScreen = new int[2];
        view.getDrawingRect(boundsRect);
        view.getLocationOnScreen(locationOnScreen);
        boundsRect.offset(locationOnScreen[0], locationOnScreen[1]);
        boolean isInBounds = boundsRect.contains((int)x, (int)y);
        return isInBounds;
    }

    private static final AndroidActionEventHandle addSingleTouchAndroidEventHandle(Object target, Function1<? super KPointerEvent, Unit> listener, EventType type, int action) {
        AndroidActionEventHandle androidActionEventHandle;
        AndroidCanvasRenderer renderer2 = (AndroidCanvasRenderer)target;
        VizTouchListener handler2 = new VizTouchListener(action, type, listener){
            final /* synthetic */ int $action;
            final /* synthetic */ EventType $type;
            final /* synthetic */ Function1<KPointerEvent, Unit> $listener;
            {
                this.$action = $action;
                this.$type = $type;
                this.$listener = $listener;
            }

            public boolean onTouchEvent(@NotNull View view, @Nullable MotionEvent event) {
                Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                MotionEvent motionEvent = event;
                boolean bl = motionEvent != null ? motionEvent.getPointerCount() == 1 : false;
                if (bl && event.getAction() == this.$action) {
                    KPointerEvent kevent = AndroidEventsKt.access$toKPointerEvent(event, this.$type);
                    this.$listener.invoke((Object)kevent);
                }
                return true;
            }
        };
        AndroidActionEventHandle it = androidActionEventHandle = new AndroidActionEventHandle(renderer2, action, handler2);
        boolean bl = false;
        it.init();
        return androidActionEventHandle;
    }

    @NotNull
    public static final <T extends KEvent> Disposable addNativeEventListenerFromHandle(@NotNull VizRenderer $this$addNativeEventListenerFromHandle, @NotNull KEventHandle<T> handle) {
        Intrinsics.checkNotNullParameter((Object)$this$addNativeEventListenerFromHandle, (String)"<this>");
        Intrinsics.checkNotNullParameter(handle, (String)"handle");
        AndroidCanvasRenderer androidCanvasRenderer = (AndroidCanvasRenderer)$this$addNativeEventListenerFromHandle;
        return handle.getEventListener().addNativeListener(androidCanvasRenderer, handle.getListener());
    }

    /*
     * WARNING - void declaration
     */
    private static final KPointerEvent toKPointerEvent(MotionEvent $this$toKPointerEvent, EventType type) {
        ArrayList<KPointer> arrayList;
        int n = $this$toKPointerEvent.getPointerCount();
        int n2 = $this$toKPointerEvent.getActionIndex();
        MouseButtonPressed mouseButtonPressed = AndroidEventsKt.pressedMouseButton($this$toKPointerEvent);
        PointerType pointerType = AndroidEventsKt.pointerType($this$toKPointerEvent);
        EventType eventType = type;
        Point point = new Point((double)$this$toKPointerEvent.getX() / (double)AndroidCanvasRendererKt.getDensity(), (double)$this$toKPointerEvent.getY() / (double)AndroidCanvasRendererKt.getDensity());
        ArrayList<KPointer> arrayList2 = new ArrayList<KPointer>(n);
        int n3 = 0;
        while (n3 < n) {
            void index;
            int n4;
            int n5 = n4 = n3++;
            arrayList = arrayList2;
            boolean bl = false;
            arrayList.add(new KPointer($this$toKPointerEvent.getPointerId((int)index), new Point((double)$this$toKPointerEvent.getX((int)index) / (double)AndroidCanvasRendererKt.getDensity(), (double)$this$toKPointerEvent.getY((int)index) / (double)AndroidCanvasRendererKt.getDensity())));
        }
        arrayList = arrayList2;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        ArrayList<KPointer> arrayList3 = arrayList;
        int n6 = n2;
        MouseButtonPressed mouseButtonPressed2 = mouseButtonPressed;
        PointerType pointerType2 = pointerType;
        EventType eventType2 = eventType;
        Point point2 = point;
        return new KPointerEventImpl(point2, eventType2, pointerType2, mouseButtonPressed2, n6, arrayList3, bl4, bl3, bl2, bl);
    }

    private static final EventType actionMaskToEventType(int $this$actionMaskToEventType) {
        EventType eventType;
        switch ($this$actionMaskToEventType) {
            case 0: 
            case 5: {
                eventType = EventType.Down;
                break;
            }
            case 2: {
                eventType = EventType.Move;
                break;
            }
            case 1: 
            case 6: {
                eventType = EventType.Up;
                break;
            }
            default: {
                eventType = EventType.Cancel;
            }
        }
        return eventType;
    }

    private static final PointerType pointerType(MotionEvent $this$pointerType) {
        PointerType pointerType;
        switch ($this$pointerType.getToolType(0)) {
            case 1: {
                pointerType = PointerType.Touch;
                break;
            }
            case 3: {
                pointerType = PointerType.Mouse;
                break;
            }
            case 2: {
                pointerType = PointerType.Pen;
                break;
            }
            case 4: {
                pointerType = PointerType.Unknown;
                break;
            }
            case 0: {
                pointerType = PointerType.Unknown;
                break;
            }
            default: {
                pointerType = PointerType.Unknown;
            }
        }
        return pointerType;
    }

    private static final MouseButtonPressed pressedMouseButton(MotionEvent $this$pressedMouseButton) {
        if (Build.VERSION.SDK_INT < 21) {
            return MouseButtonPressed.NotApplicable;
        }
        return $this$pressedMouseButton.isButtonPressed(1) ? MouseButtonPressed.Left : ($this$pressedMouseButton.isButtonPressed(2) ? MouseButtonPressed.Right : ($this$pressedMouseButton.isButtonPressed(4) ? MouseButtonPressed.Middle : ($this$pressedMouseButton.isButtonPressed(16) ? MouseButtonPressed.Fourth : ($this$pressedMouseButton.isButtonPressed(8) ? MouseButtonPressed.Fifth : MouseButtonPressed.NotApplicable))));
    }

    public static final /* synthetic */ boolean access$checkIsViewInBounds(View view, float x, float y) {
        return AndroidEventsKt.checkIsViewInBounds(view, x, y);
    }

    public static final /* synthetic */ AndroidActionEventHandle access$addSingleTouchAndroidEventHandle(Object target, Function1 listener, EventType type, int action) {
        return AndroidEventsKt.addSingleTouchAndroidEventHandle(target, (Function1<? super KPointerEvent, Unit>)listener, type, action);
    }

    public static final /* synthetic */ AndroidActionEventHandle access$enterLeaveEventHandler(boolean enter, Object target, Function1 listener) {
        return AndroidEventsKt.enterLeaveEventHandler(enter, target, (Function1<? super KPointerEvent, Unit>)listener);
    }

    public static final /* synthetic */ AndroidActionEventHandle access$clickEventHandler(Object target, Function1 listener) {
        return AndroidEventsKt.clickEventHandler(target, (Function1<? super KPointerEvent, Unit>)listener);
    }

    public static final /* synthetic */ AndroidActionEventHandle access$doubleClickEventHandler(Object target, Function1 listener) {
        return AndroidEventsKt.doubleClickEventHandler(target, (Function1<? super KPointerEvent, Unit>)listener);
    }

    public static final /* synthetic */ KPointerEvent access$toKPointerEvent(MotionEvent $receiver, EventType type) {
        return AndroidEventsKt.toKPointerEvent($receiver, type);
    }

    public static final /* synthetic */ double access$getEpsilon$p() {
        return epsilon;
    }
}

