/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.query;

import io.cucumber.messages.types.Examples;
import io.cucumber.messages.types.Feature;
import io.cucumber.messages.types.FeatureChild;
import io.cucumber.messages.types.GherkinDocument;
import io.cucumber.messages.types.Rule;
import io.cucumber.messages.types.RuleChild;
import io.cucumber.messages.types.Scenario;
import io.cucumber.messages.types.TableRow;
import io.cucumber.query.Lineage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

final class Lineages {
    private Lineages() {
    }

    static Map<String, Lineage> of(GherkinDocument document) {
        HashMap<String, Lineage> elements = new HashMap<String, Lineage>();
        Lineage lineage = new Lineage(document);
        String uri = (String)document.getUri().orElseThrow(() -> new IllegalArgumentException("document.uri must not be null"));
        elements.put(uri, lineage);
        document.getFeature().ifPresent(Lineages.ofFeature(lineage, elements));
        return elements;
    }

    private static Consumer<Feature> ofFeature(Lineage parent, Map<String, Lineage> elements) {
        return feature -> {
            Lineage lineage = new Lineage(parent, (Feature)feature);
            feature.getChildren().forEach(Lineages.ofFeatureChild(lineage, elements));
        };
    }

    private static Consumer<FeatureChild> ofFeatureChild(Lineage parent, Map<String, Lineage> elements) {
        return featureChild -> {
            featureChild.getScenario().ifPresent(Lineages.ofScenario(parent, elements));
            featureChild.getRule().ifPresent(Lineages.ofRule(parent, elements));
        };
    }

    private static Consumer<Rule> ofRule(Lineage parent, Map<String, Lineage> elements) {
        return rule -> {
            Lineage lineage = new Lineage(parent, (Rule)rule);
            elements.put(rule.getId(), lineage);
            rule.getChildren().forEach(Lineages.ofRuleChild(lineage, elements));
        };
    }

    private static Consumer<RuleChild> ofRuleChild(Lineage parent, Map<String, Lineage> elements) {
        return ruleChild -> ruleChild.getScenario().ifPresent(Lineages.ofScenario(parent, elements));
    }

    private static Consumer<Scenario> ofScenario(Lineage parent, Map<String, Lineage> elements) {
        return scenario -> {
            Lineage lineage = new Lineage(parent, (Scenario)scenario);
            elements.put(scenario.getId(), lineage);
            Lineages.forEachIndexed(scenario.getExamples(), Lineages.ofExamples(lineage, elements));
        };
    }

    private static BiConsumer<Examples, Integer> ofExamples(Lineage parent, Map<String, Lineage> elements) {
        return (examples, examplesIndex) -> {
            Lineage lineage = new Lineage(parent, (Examples)examples, (int)examplesIndex);
            elements.put(examples.getId(), lineage);
            Lineages.forEachIndexed(examples.getTableBody(), Lineages.ofExample(lineage, elements));
        };
    }

    private static BiConsumer<TableRow, Integer> ofExample(Lineage parent, Map<String, Lineage> elements) {
        return (example, exampleIndex) -> {
            Lineage lineage = new Lineage(parent, (TableRow)example, (int)exampleIndex);
            elements.put(example.getId(), lineage);
        };
    }

    private static <T> void forEachIndexed(List<T> items, BiConsumer<T, Integer> consumer) {
        for (int i = 0; i < items.size(); ++i) {
            consumer.accept(items.get(i), i);
        }
    }
}

