/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.prettyformatter;

import io.cucumber.messages.types.TestStepResultStatus;
import io.cucumber.prettyformatter.Ansi;
import java.util.AbstractMap;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;

public final class Theme {
    private final Map<Element, Map.Entry<Ansi, Ansi>> styleByElement;
    private final Map<Element, Map<TestStepResultStatus, Map.Entry<Ansi, Ansi>>> styleByStatusByElement;

    private Theme(Map<Element, Map.Entry<Ansi, Ansi>> styleByElement, Map<Element, Map<TestStepResultStatus, Map.Entry<Ansi, Ansi>>> styleByStatusByElement) {
        this.styleByElement = Objects.requireNonNull(styleByElement);
        this.styleByStatusByElement = Objects.requireNonNull(styleByStatusByElement);
    }

    public static Theme cucumber() {
        return Theme.builder().style(Element.ATTACHMENT, Ansi.with(Ansi.Attributes.FOREGROUND_BLUE), Ansi.with(Ansi.Attributes.RESET)).style(Element.FEATURE_KEYWORD, Ansi.with(Ansi.Attributes.BOLD), Ansi.with(Ansi.Attributes.BOLD_OFF)).style(Element.LOCATION, Ansi.with(Ansi.Attributes.FOREGROUND_BRIGHT_BLACK), Ansi.with(Ansi.Attributes.RESET)).style(Element.RULE_KEYWORD, Ansi.with(Ansi.Attributes.BOLD), Ansi.with(Ansi.Attributes.BOLD_OFF)).style(Element.SCENARIO_KEYWORD, Ansi.with(Ansi.Attributes.BOLD), Ansi.with(Ansi.Attributes.BOLD_OFF)).style(Element.STEP, TestStepResultStatus.AMBIGUOUS, Ansi.with(Ansi.Attributes.FOREGROUND_RED), Ansi.with(Ansi.Attributes.RESET)).style(Element.STEP, TestStepResultStatus.FAILED, Ansi.with(Ansi.Attributes.FOREGROUND_RED), Ansi.with(Ansi.Attributes.RESET)).style(Element.STEP, TestStepResultStatus.PASSED, Ansi.with(Ansi.Attributes.FOREGROUND_GREEN), Ansi.with(Ansi.Attributes.RESET)).style(Element.STEP, TestStepResultStatus.PENDING, Ansi.with(Ansi.Attributes.FOREGROUND_YELLOW), Ansi.with(Ansi.Attributes.RESET)).style(Element.STEP, TestStepResultStatus.SKIPPED, Ansi.with(Ansi.Attributes.FOREGROUND_CYAN), Ansi.with(Ansi.Attributes.RESET)).style(Element.STEP, TestStepResultStatus.UNDEFINED, Ansi.with(Ansi.Attributes.FOREGROUND_YELLOW), Ansi.with(Ansi.Attributes.RESET)).style(Element.STEP_ARGUMENT, Ansi.with(Ansi.Attributes.BOLD), Ansi.with(Ansi.Attributes.BOLD_OFF)).style(Element.STEP_KEYWORD, Ansi.with(Ansi.Attributes.BOLD), Ansi.with(Ansi.Attributes.BOLD_OFF)).build();
    }

    public static Theme none() {
        return Theme.builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    String style(Element element, String text) {
        Map.Entry<Ansi, Ansi> ansiStyle = this.findAnsiBy(element);
        return ansiStyle == null ? text : ansiStyle.getKey() + text + ansiStyle.getValue();
    }

    String beginStyle(Element element) {
        Map.Entry<Ansi, Ansi> style = this.findAnsiBy(element);
        return style == null ? "" : style.getKey().toString();
    }

    String beginStyle(Element element, TestStepResultStatus status) {
        Map.Entry<Ansi, Ansi> style = this.findAnsiBy(element, status);
        return style == null ? "" : style.getKey().toString();
    }

    String endStyle(Element element) {
        Map.Entry<Ansi, Ansi> style = this.findAnsiBy(element);
        return style == null ? "" : style.getValue().toString();
    }

    String endStyle(Element element, TestStepResultStatus status) {
        Map.Entry<Ansi, Ansi> style = this.findAnsiBy(element, status);
        return style == null ? "" : style.getValue().toString();
    }

    private Map.Entry<Ansi, Ansi> findAnsiBy(Element element) {
        return this.styleByElement.get((Object)element);
    }

    private Map.Entry<Ansi, Ansi> findAnsiBy(Element element, TestStepResultStatus status) {
        Map<TestStepResultStatus, Map.Entry<Ansi, Ansi>> styleByStatus = this.styleByStatusByElement.get((Object)element);
        return styleByStatus == null ? null : styleByStatus.get(status);
    }

    public static class Builder {
        private final Map<Element, Map.Entry<Ansi, Ansi>> styleByElement = new EnumMap<Element, Map.Entry<Ansi, Ansi>>(Element.class);
        private final Map<Element, Map<TestStepResultStatus, Map.Entry<Ansi, Ansi>>> styleByStatusByElement = new EnumMap<Element, Map<TestStepResultStatus, Map.Entry<Ansi, Ansi>>>(Element.class);

        private Builder() {
        }

        public Builder style(Element element, Ansi style, Ansi resetStyle) {
            Objects.requireNonNull(element);
            Objects.requireNonNull(style);
            Objects.requireNonNull(resetStyle);
            this.styleByElement.put(element, new AbstractMap.SimpleEntry<Ansi, Ansi>(style, resetStyle));
            return this;
        }

        public Builder style(Element element, TestStepResultStatus status, Ansi style, Ansi resetStyle) {
            Objects.requireNonNull(element);
            Objects.requireNonNull(status);
            Objects.requireNonNull(style);
            Objects.requireNonNull(resetStyle);
            this.styleByStatusByElement.computeIfAbsent(element, e1 -> new EnumMap(TestStepResultStatus.class)).put(status, new AbstractMap.SimpleEntry<Ansi, Ansi>(style, resetStyle));
            return this;
        }

        public Theme build() {
            return new Theme(this.styleByElement, this.styleByStatusByElement);
        }
    }

    public static enum Element {
        ATTACHMENT,
        DATA_TABLE,
        DATA_TABLE_BORDER,
        DATA_TABLE_CONTENT,
        DOC_STRING,
        DOC_STRING_CONTENT,
        DOC_STRING_MEDIA_TYPE,
        DOC_STRING_DELIMITER,
        FEATURE,
        FEATURE_KEYWORD,
        FEATURE_NAME,
        LOCATION,
        RULE,
        RULE_KEYWORD,
        RULE_NAME,
        SCENARIO,
        SCENARIO_KEYWORD,
        SCENARIO_NAME,
        STEP,
        STEP_ARGUMENT,
        STEP_KEYWORD,
        STEP_TEXT,
        TAG;

    }
}

