/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.messages.types;

import io.cucumber.messages.types.Location;
import io.cucumber.messages.types.TableCell;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public final class TableRow {
    private final Location location;
    private final List<TableCell> cells;
    private final String id;

    public TableRow(Location location, List<TableCell> cells, String id) {
        this.location = Objects.requireNonNull(location, "TableRow.location cannot be null");
        this.cells = List.copyOf((Collection)Objects.requireNonNull(cells, "TableRow.cells cannot be null"));
        this.id = Objects.requireNonNull(id, "TableRow.id cannot be null");
    }

    public Location getLocation() {
        return this.location;
    }

    public List<TableCell> getCells() {
        return this.cells;
    }

    public String getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableRow that = (TableRow)o;
        return this.location.equals(that.location) && this.cells.equals(that.cells) && this.id.equals(that.id);
    }

    public int hashCode() {
        return Objects.hash(this.location, this.cells, this.id);
    }

    public String toString() {
        return "TableRow{location=" + String.valueOf(this.location) + ", cells=" + String.valueOf(this.cells) + ", id=" + this.id + "}";
    }
}

