/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.messages.types;

import io.cucumber.messages.types.DataTable;
import io.cucumber.messages.types.DocString;
import io.cucumber.messages.types.Location;
import io.cucumber.messages.types.StepKeywordType;
import java.util.Objects;
import java.util.Optional;
import org.jspecify.annotations.Nullable;

public final class Step {
    private final Location location;
    private final String keyword;
    private final @Nullable StepKeywordType keywordType;
    private final String text;
    private final @Nullable DocString docString;
    private final @Nullable DataTable dataTable;
    private final String id;

    public Step(Location location, String keyword, @Nullable StepKeywordType keywordType, String text, @Nullable DocString docString, @Nullable DataTable dataTable, String id) {
        this.location = Objects.requireNonNull(location, "Step.location cannot be null");
        this.keyword = Objects.requireNonNull(keyword, "Step.keyword cannot be null");
        this.keywordType = keywordType;
        this.text = Objects.requireNonNull(text, "Step.text cannot be null");
        this.docString = docString;
        this.dataTable = dataTable;
        this.id = Objects.requireNonNull(id, "Step.id cannot be null");
    }

    public Location getLocation() {
        return this.location;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public Optional<StepKeywordType> getKeywordType() {
        return Optional.ofNullable(this.keywordType);
    }

    public String getText() {
        return this.text;
    }

    public Optional<DocString> getDocString() {
        return Optional.ofNullable(this.docString);
    }

    public Optional<DataTable> getDataTable() {
        return Optional.ofNullable(this.dataTable);
    }

    public String getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Step that = (Step)o;
        return this.location.equals(that.location) && this.keyword.equals(that.keyword) && Objects.equals((Object)this.keywordType, (Object)that.keywordType) && this.text.equals(that.text) && Objects.equals(this.docString, that.docString) && Objects.equals(this.dataTable, that.dataTable) && this.id.equals(that.id);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.location, this.keyword, this.keywordType, this.text, this.docString, this.dataTable, this.id});
    }

    public String toString() {
        return "Step{location=" + String.valueOf(this.location) + ", keyword=" + this.keyword + ", keywordType=" + String.valueOf((Object)this.keywordType) + ", text=" + this.text + ", docString=" + String.valueOf(this.docString) + ", dataTable=" + String.valueOf(this.dataTable) + ", id=" + this.id + "}";
    }
}

