/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.messages.types;

import java.util.Objects;

public final class Snippet {
    private final String language;
    private final String code;

    public Snippet(String language, String code) {
        this.language = Objects.requireNonNull(language, "Snippet.language cannot be null");
        this.code = Objects.requireNonNull(code, "Snippet.code cannot be null");
    }

    public String getLanguage() {
        return this.language;
    }

    public String getCode() {
        return this.code;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Snippet that = (Snippet)o;
        return this.language.equals(that.language) && this.code.equals(that.code);
    }

    public int hashCode() {
        return Objects.hash(this.language, this.code);
    }

    public String toString() {
        return "Snippet{language=" + this.language + ", code=" + this.code + "}";
    }
}

