/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.messages.types;

import io.cucumber.messages.types.StepMatchArgumentsList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.jspecify.annotations.Nullable;

public final class TestStep {
    private final @Nullable String hookId;
    private final String id;
    private final @Nullable String pickleStepId;
    private final @Nullable List<String> stepDefinitionIds;
    private final @Nullable List<StepMatchArgumentsList> stepMatchArgumentsLists;

    public TestStep(@Nullable String hookId, String id, @Nullable String pickleStepId, @Nullable List<String> stepDefinitionIds, @Nullable List<StepMatchArgumentsList> stepMatchArgumentsLists) {
        this.hookId = hookId;
        this.id = Objects.requireNonNull(id, "TestStep.id cannot be null");
        this.pickleStepId = pickleStepId;
        this.stepDefinitionIds = stepDefinitionIds == null ? null : List.copyOf(stepDefinitionIds);
        this.stepMatchArgumentsLists = stepMatchArgumentsLists == null ? null : List.copyOf(stepMatchArgumentsLists);
    }

    public Optional<String> getHookId() {
        return Optional.ofNullable(this.hookId);
    }

    public String getId() {
        return this.id;
    }

    public Optional<String> getPickleStepId() {
        return Optional.ofNullable(this.pickleStepId);
    }

    public Optional<List<String>> getStepDefinitionIds() {
        return Optional.ofNullable(this.stepDefinitionIds);
    }

    public Optional<List<StepMatchArgumentsList>> getStepMatchArgumentsLists() {
        return Optional.ofNullable(this.stepMatchArgumentsLists);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestStep that = (TestStep)o;
        return Objects.equals(this.hookId, that.hookId) && this.id.equals(that.id) && Objects.equals(this.pickleStepId, that.pickleStepId) && Objects.equals(this.stepDefinitionIds, that.stepDefinitionIds) && Objects.equals(this.stepMatchArgumentsLists, that.stepMatchArgumentsLists);
    }

    public int hashCode() {
        return Objects.hash(this.hookId, this.id, this.pickleStepId, this.stepDefinitionIds, this.stepMatchArgumentsLists);
    }

    public String toString() {
        return "TestStep{hookId=" + this.hookId + ", id=" + this.id + ", pickleStepId=" + this.pickleStepId + ", stepDefinitionIds=" + String.valueOf(this.stepDefinitionIds) + ", stepMatchArgumentsLists=" + String.valueOf(this.stepMatchArgumentsLists) + "}";
    }
}

