/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.messages.types;

import io.cucumber.messages.types.Snippet;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public final class Suggestion {
    private final String id;
    private final String pickleStepId;
    private final List<Snippet> snippets;

    public Suggestion(String id, String pickleStepId, List<Snippet> snippets) {
        this.id = Objects.requireNonNull(id, "Suggestion.id cannot be null");
        this.pickleStepId = Objects.requireNonNull(pickleStepId, "Suggestion.pickleStepId cannot be null");
        this.snippets = List.copyOf((Collection)Objects.requireNonNull(snippets, "Suggestion.snippets cannot be null"));
    }

    public String getId() {
        return this.id;
    }

    public String getPickleStepId() {
        return this.pickleStepId;
    }

    public List<Snippet> getSnippets() {
        return this.snippets;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Suggestion that = (Suggestion)o;
        return this.id.equals(that.id) && this.pickleStepId.equals(that.pickleStepId) && this.snippets.equals(that.snippets);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.pickleStepId, this.snippets);
    }

    public String toString() {
        return "Suggestion{id=" + this.id + ", pickleStepId=" + this.pickleStepId + ", snippets=" + String.valueOf(this.snippets) + "}";
    }
}

