/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.messages.types;

import io.cucumber.messages.types.PickleStepArgument;
import io.cucumber.messages.types.PickleStepType;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.jspecify.annotations.Nullable;

public final class PickleStep {
    private final @Nullable PickleStepArgument argument;
    private final List<String> astNodeIds;
    private final String id;
    private final @Nullable PickleStepType type;
    private final String text;

    public PickleStep(@Nullable PickleStepArgument argument, List<String> astNodeIds, String id, @Nullable PickleStepType type, String text) {
        this.argument = argument;
        this.astNodeIds = List.copyOf((Collection)Objects.requireNonNull(astNodeIds, "PickleStep.astNodeIds cannot be null"));
        this.id = Objects.requireNonNull(id, "PickleStep.id cannot be null");
        this.type = type;
        this.text = Objects.requireNonNull(text, "PickleStep.text cannot be null");
    }

    public Optional<PickleStepArgument> getArgument() {
        return Optional.ofNullable(this.argument);
    }

    public List<String> getAstNodeIds() {
        return this.astNodeIds;
    }

    public String getId() {
        return this.id;
    }

    public Optional<PickleStepType> getType() {
        return Optional.ofNullable(this.type);
    }

    public String getText() {
        return this.text;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PickleStep that = (PickleStep)o;
        return Objects.equals(this.argument, that.argument) && this.astNodeIds.equals(that.astNodeIds) && this.id.equals(that.id) && Objects.equals((Object)this.type, (Object)that.type) && this.text.equals(that.text);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.argument, this.astNodeIds, this.id, this.type, this.text});
    }

    public String toString() {
        return "PickleStep{argument=" + String.valueOf(this.argument) + ", astNodeIds=" + String.valueOf(this.astNodeIds) + ", id=" + this.id + ", type=" + String.valueOf((Object)this.type) + ", text=" + this.text + "}";
    }
}

