/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.messages.types;

import io.cucumber.messages.types.Ci;
import io.cucumber.messages.types.Product;
import java.util.Objects;
import java.util.Optional;
import org.jspecify.annotations.Nullable;

public final class Meta {
    private final String protocolVersion;
    private final Product implementation;
    private final Product runtime;
    private final Product os;
    private final Product cpu;
    private final @Nullable Ci ci;

    public Meta(String protocolVersion, Product implementation, Product runtime, Product os, Product cpu, @Nullable Ci ci) {
        this.protocolVersion = Objects.requireNonNull(protocolVersion, "Meta.protocolVersion cannot be null");
        this.implementation = Objects.requireNonNull(implementation, "Meta.implementation cannot be null");
        this.runtime = Objects.requireNonNull(runtime, "Meta.runtime cannot be null");
        this.os = Objects.requireNonNull(os, "Meta.os cannot be null");
        this.cpu = Objects.requireNonNull(cpu, "Meta.cpu cannot be null");
        this.ci = ci;
    }

    public String getProtocolVersion() {
        return this.protocolVersion;
    }

    public Product getImplementation() {
        return this.implementation;
    }

    public Product getRuntime() {
        return this.runtime;
    }

    public Product getOs() {
        return this.os;
    }

    public Product getCpu() {
        return this.cpu;
    }

    public Optional<Ci> getCi() {
        return Optional.ofNullable(this.ci);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Meta that = (Meta)o;
        return this.protocolVersion.equals(that.protocolVersion) && this.implementation.equals(that.implementation) && this.runtime.equals(that.runtime) && this.os.equals(that.os) && this.cpu.equals(that.cpu) && Objects.equals(this.ci, that.ci);
    }

    public int hashCode() {
        return Objects.hash(this.protocolVersion, this.implementation, this.runtime, this.os, this.cpu, this.ci);
    }

    public String toString() {
        return "Meta{protocolVersion=" + this.protocolVersion + ", implementation=" + String.valueOf(this.implementation) + ", runtime=" + String.valueOf(this.runtime) + ", os=" + String.valueOf(this.os) + ", cpu=" + String.valueOf(this.cpu) + ", ci=" + String.valueOf(this.ci) + "}";
    }
}

