/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.messages.types;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.jspecify.annotations.Nullable;

public final class Group {
    private final @Nullable List<Group> children;
    private final @Nullable Integer start;
    private final @Nullable String value;

    public static Group of(List<Group> children) {
        return new Group(List.copyOf((Collection)Objects.requireNonNull(children, "Group.children cannot be null")), null, null);
    }

    public static Group of(Integer start) {
        return new Group(null, Objects.requireNonNull(start, "Group.start cannot be null"), null);
    }

    public static Group of(String value) {
        return new Group(null, null, Objects.requireNonNull(value, "Group.value cannot be null"));
    }

    public Group(@Nullable List<Group> children, @Nullable Integer start, @Nullable String value) {
        this.children = children == null ? null : List.copyOf(children);
        this.start = start;
        this.value = value;
    }

    public Optional<List<Group>> getChildren() {
        return Optional.ofNullable(this.children);
    }

    public Optional<Integer> getStart() {
        return Optional.ofNullable(this.start);
    }

    public Optional<String> getValue() {
        return Optional.ofNullable(this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Group that = (Group)o;
        return Objects.equals(this.children, that.children) && Objects.equals(this.start, that.start) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.children, this.start, this.value);
    }

    public String toString() {
        return "Group{children=" + String.valueOf(this.children) + ", start=" + this.start + ", value=" + this.value + "}";
    }
}

