/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.messages.types;

import io.cucumber.messages.types.Timestamp;
import java.util.Objects;
import java.util.Optional;
import org.jspecify.annotations.Nullable;

public final class ExternalAttachment {
    private final String url;
    private final String mediaType;
    private final @Nullable String testStepId;
    private final @Nullable String testCaseStartedId;
    private final @Nullable String testRunHookStartedId;
    private final @Nullable Timestamp timestamp;

    public ExternalAttachment(String url, String mediaType, @Nullable String testStepId, @Nullable String testCaseStartedId, @Nullable String testRunHookStartedId, @Nullable Timestamp timestamp) {
        this.url = Objects.requireNonNull(url, "ExternalAttachment.url cannot be null");
        this.mediaType = Objects.requireNonNull(mediaType, "ExternalAttachment.mediaType cannot be null");
        this.testStepId = testStepId;
        this.testCaseStartedId = testCaseStartedId;
        this.testRunHookStartedId = testRunHookStartedId;
        this.timestamp = timestamp;
    }

    public String getUrl() {
        return this.url;
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public Optional<String> getTestStepId() {
        return Optional.ofNullable(this.testStepId);
    }

    public Optional<String> getTestCaseStartedId() {
        return Optional.ofNullable(this.testCaseStartedId);
    }

    public Optional<String> getTestRunHookStartedId() {
        return Optional.ofNullable(this.testRunHookStartedId);
    }

    public Optional<Timestamp> getTimestamp() {
        return Optional.ofNullable(this.timestamp);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExternalAttachment that = (ExternalAttachment)o;
        return this.url.equals(that.url) && this.mediaType.equals(that.mediaType) && Objects.equals(this.testStepId, that.testStepId) && Objects.equals(this.testCaseStartedId, that.testCaseStartedId) && Objects.equals(this.testRunHookStartedId, that.testRunHookStartedId) && Objects.equals(this.timestamp, that.timestamp);
    }

    public int hashCode() {
        return Objects.hash(this.url, this.mediaType, this.testStepId, this.testCaseStartedId, this.testRunHookStartedId, this.timestamp);
    }

    public String toString() {
        return "ExternalAttachment{url=" + this.url + ", mediaType=" + this.mediaType + ", testStepId=" + this.testStepId + ", testCaseStartedId=" + this.testCaseStartedId + ", testRunHookStartedId=" + this.testRunHookStartedId + ", timestamp=" + String.valueOf(this.timestamp) + "}";
    }
}

