/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.messages.com.google.gson.internal.bind;

import io.cucumber.messages.com.google.gson.Gson;
import io.cucumber.messages.com.google.gson.JsonSyntaxException;
import io.cucumber.messages.com.google.gson.TypeAdapter;
import io.cucumber.messages.com.google.gson.TypeAdapterFactory;
import io.cucumber.messages.com.google.gson.reflect.TypeToken;
import io.cucumber.messages.com.google.gson.stream.JsonReader;
import io.cucumber.messages.com.google.gson.stream.JsonToken;
import io.cucumber.messages.com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.sql.Date;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;

public final class SqlDateTypeAdapter
extends TypeAdapter<Date> {
    public static final TypeAdapterFactory FACTORY = new TypeAdapterFactory(){

        @Override
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
            return typeToken.getRawType() == Date.class ? new SqlDateTypeAdapter() : null;
        }
    };
    private final DateFormat format = new SimpleDateFormat("MMM d, yyyy");

    @Override
    public synchronized Date read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        try {
            long utilDate = this.format.parse(in.nextString()).getTime();
            return new Date(utilDate);
        }
        catch (ParseException e) {
            throw new JsonSyntaxException(e);
        }
    }

    @Override
    public synchronized void write(JsonWriter out, Date value) throws IOException {
        out.value(value == null ? null : this.format.format(value));
    }
}

