/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.docstring;

import io.cucumber.docstring.CucumberDocStringException;
import io.cucumber.docstring.DocString;
import java.io.IOException;
import java.util.Objects;
import org.apiguardian.api.API;

@API(status=API.Status.EXPERIMENTAL)
public final class DocStringFormatter {
    private final String indentation;

    private DocStringFormatter(String indentation) {
        this.indentation = indentation;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String format(DocString docString) {
        StringBuilder result = new StringBuilder();
        this.formatTo(docString, result);
        return result.toString();
    }

    public void formatTo(DocString docString, StringBuilder appendable) {
        Objects.requireNonNull(docString, "docString may not be null");
        Objects.requireNonNull(appendable, "appendable may not be null");
        try {
            this.formatTo(docString, (Appendable)appendable);
        }
        catch (IOException e) {
            throw new CucumberDocStringException(e.getMessage(), e);
        }
    }

    public void formatTo(DocString docString, Appendable out) throws IOException {
        String printableContentType = docString.getContentType() == null ? "" : docString.getContentType();
        out.append(this.indentation).append("\"\"\"").append(printableContentType).append("\n");
        for (String l : docString.getContent().split("\\n")) {
            out.append(this.indentation).append(l).append("\n");
        }
        out.append(this.indentation).append("\"\"\"").append("\n");
    }

    public static final class Builder {
        private String indentation = "";

        private Builder() {
        }

        public Builder indentation(String indentation) {
            Objects.requireNonNull(indentation, "indentation may not be null");
            this.indentation = indentation;
            return this;
        }

        public DocStringFormatter build() {
            return new DocStringFormatter(this.indentation);
        }
    }
}

