/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.docstring;

import io.cucumber.docstring.CucumberDocStringException;
import io.cucumber.docstring.DocStringType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE)
public final class DocStringTypeRegistry {
    private final Map<String, DocStringType> docStringTypesByContentType = new HashMap<String, DocStringType>();
    private final Map<Type, DocStringType> docStringTypesByType = new HashMap<Type, DocStringType>();

    public DocStringTypeRegistry() {
        this.defineDocStringType(new DocStringType((Type)((Object)String.class), "", docString -> docString));
    }

    DocStringType lookupByContentType(String contentType) {
        return this.docStringTypesByContentType.get(contentType);
    }

    DocStringType lookupByType(Type type) {
        return this.docStringTypesByType.get(type);
    }

    public void defineDocStringType(DocStringType docStringType) {
        DocStringType byContentType = this.docStringTypesByContentType.get(docStringType.getContentType());
        if (byContentType != null) {
            throw DocStringTypeRegistry.createDuplicateTypeException(byContentType, docStringType);
        }
        DocStringType byClass = this.docStringTypesByType.get(docStringType.getType());
        if (byClass != null) {
            throw DocStringTypeRegistry.createDuplicateTypeException(byClass, docStringType);
        }
        this.docStringTypesByContentType.put(docStringType.getContentType(), docStringType);
        this.docStringTypesByType.put(docStringType.getType(), docStringType);
    }

    private static CucumberDocStringException createDuplicateTypeException(DocStringType existing, DocStringType docStringType) {
        String contentType = existing.getContentType();
        return new CucumberDocStringException(String.format("There is already docstring type registered for '%s' and %s.\nYou are trying to add '%s' and %s", DocStringTypeRegistry.emptyToAnonymous(contentType), existing.getType().getTypeName(), DocStringTypeRegistry.emptyToAnonymous(docStringType.getContentType()), docStringType.getType().getTypeName()));
    }

    private static String emptyToAnonymous(String contentType) {
        return contentType.isEmpty() ? "[anonymous]" : contentType;
    }
}

