/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.datatable;

import io.cucumber.datatable.DataTableCellByTypeTransformer;
import io.cucumber.datatable.DataTableType;
import io.cucumber.datatable.DuplicateTypeException;
import io.cucumber.datatable.NumberParser;
import io.cucumber.datatable.TableCellByTypeTransformer;
import io.cucumber.datatable.TableCellTransformer;
import io.cucumber.datatable.TableEntryByTypeTransformer;
import io.cucumber.datatable.TypeFactory;
import io.cucumber.datatable.dependency.com.fasterxml.jackson.databind.JavaType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE)
public final class DataTableTypeRegistry {
    private final DataTableCellByTypeTransformer tableCellByTypeTransformer = new DataTableCellByTypeTransformer(this);
    private final Map<JavaType, DataTableType> tableTypeByType = new HashMap<JavaType, DataTableType>();
    private TableEntryByTypeTransformer defaultDataTableEntryTransformer;
    private TableCellByTypeTransformer defaultDataTableCellTransformer;

    public DataTableTypeRegistry(Locale locale) {
        NumberParser numberParser = new NumberParser(locale);
        TableCellTransformer<BigInteger> bigIntegerTableCellTransformer = DataTableTypeRegistry.applyIfPresent(BigInteger::new);
        this.defineDataTableType(new DataTableType(BigInteger.class, bigIntegerTableCellTransformer));
        TableCellTransformer<BigDecimal> bigDecimalTableCellTransformer = DataTableTypeRegistry.applyIfPresent(numberParser::parseBigDecimal);
        this.defineDataTableType(new DataTableType(BigDecimal.class, bigDecimalTableCellTransformer));
        TableCellTransformer<Byte> byteTableCellTransformer = DataTableTypeRegistry.applyIfPresent(Byte::decode);
        this.defineDataTableType(new DataTableType(Byte.class, byteTableCellTransformer));
        this.defineDataTableType(new DataTableType(Byte.TYPE, byteTableCellTransformer));
        TableCellTransformer<Short> shortTableCellTransformer = DataTableTypeRegistry.applyIfPresent(Short::decode);
        this.defineDataTableType(new DataTableType(Short.class, shortTableCellTransformer));
        this.defineDataTableType(new DataTableType(Short.TYPE, shortTableCellTransformer));
        TableCellTransformer<Integer> integerTableCellTransformer = DataTableTypeRegistry.applyIfPresent(Integer::decode);
        this.defineDataTableType(new DataTableType(Integer.class, integerTableCellTransformer));
        this.defineDataTableType(new DataTableType(Integer.TYPE, integerTableCellTransformer));
        TableCellTransformer<Long> longTableCellTransformer = DataTableTypeRegistry.applyIfPresent(Long::decode);
        this.defineDataTableType(new DataTableType(Long.class, longTableCellTransformer));
        this.defineDataTableType(new DataTableType(Long.TYPE, longTableCellTransformer));
        TableCellTransformer<Float> floatTableCellTransformer = DataTableTypeRegistry.applyIfPresent(numberParser::parseFloat);
        this.defineDataTableType(new DataTableType(Float.class, floatTableCellTransformer));
        this.defineDataTableType(new DataTableType(Float.TYPE, floatTableCellTransformer));
        TableCellTransformer<Double> doubleTableCellTransformer = DataTableTypeRegistry.applyIfPresent(numberParser::parseDouble);
        this.defineDataTableType(new DataTableType(Double.class, doubleTableCellTransformer));
        this.defineDataTableType(new DataTableType(Double.TYPE, doubleTableCellTransformer));
        TableCellTransformer<String> stringTableCellTransformer = cell -> cell;
        this.defineDataTableType(new DataTableType(String.class, stringTableCellTransformer));
    }

    private static <R> TableCellTransformer<R> applyIfPresent(Function<String, R> f) {
        return s -> s == null ? null : f.apply(s);
    }

    public void defineDataTableType(DataTableType dataTableType) {
        DataTableType existing = this.tableTypeByType.get(dataTableType.getTargetType());
        if (existing != null) {
            throw new DuplicateTypeException(String.format("There is already a data table type registered for %s.\nIt registered an %s. You are trying to add a %s", dataTableType.getElementType(), dataTableType.getTransformerType().getSimpleName(), existing.getTransformerType().getSimpleName()));
        }
        this.tableTypeByType.put(dataTableType.getTargetType(), dataTableType);
    }

    DataTableType lookupTableTypeByType(Type tableType) {
        JavaType targetType = TypeFactory.constructType(tableType);
        return this.tableTypeByType.get(targetType);
    }

    DataTableType getDefaultTableCellTransformer(Type tableType) {
        if (this.defaultDataTableCellTransformer == null) {
            return null;
        }
        JavaType targetType = TypeFactory.constructType(tableType);
        return DataTableType.defaultCell(targetType.getRawClass(), this.defaultDataTableCellTransformer);
    }

    DataTableType getDefaultTableEntryTransformer(Type tableType) {
        if (this.defaultDataTableEntryTransformer == null) {
            return null;
        }
        JavaType targetType = TypeFactory.constructType(tableType);
        return DataTableType.defaultEntry(targetType.getRawClass(), this.defaultDataTableEntryTransformer, this.tableCellByTypeTransformer);
    }

    public void setDefaultDataTableEntryTransformer(TableEntryByTypeTransformer defaultDataTableEntryTransformer) {
        this.defaultDataTableEntryTransformer = defaultDataTableEntryTransformer;
    }

    public void setDefaultDataTableCellTransformer(TableCellByTypeTransformer defaultDataTableCellTransformer) {
        this.defaultDataTableCellTransformer = defaultDataTableCellTransformer;
    }
}

