/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.datatable;

import io.cucumber.datatable.ConversionRequired;
import io.cucumber.datatable.CucumberDataTableException;
import io.cucumber.datatable.DataTable;
import io.cucumber.datatable.TableCellTransformer;
import io.cucumber.datatable.TableEntryTransformer;
import io.cucumber.datatable.TableRowTransformer;
import io.cucumber.datatable.TableTransformer;
import io.cucumber.datatable.TypeFactory;
import io.cucumber.datatable.dependency.com.fasterxml.jackson.databind.JavaType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class DataTableType {
    private static final ConversionRequired CONVERSION_REQUIRED = new ConversionRequired();
    private final JavaType targetType;
    private final RawTableTransformer<?> transformer;
    private final Class<?> elementType;

    private DataTableType(Class<?> type, Type target, RawTableTransformer<?> transformer) {
        if (type == null) {
            throw new NullPointerException("targetType cannot be null");
        }
        if (target == null) {
            throw new NullPointerException("target cannot be null");
        }
        if (transformer == null) {
            throw new NullPointerException("transformer cannot be null");
        }
        this.elementType = type;
        this.targetType = TypeFactory.constructType(target);
        this.transformer = transformer;
    }

    public <T> DataTableType(Class<T> type, TableTransformer<T> transformer) {
        this(type, type, new TableTransformerAdaptor<T>(transformer));
    }

    public <T> DataTableType(Class<T> type, TableRowTransformer<T> transformer) {
        this(type, (Type)TypeFactory.aListOf(type), new TableRowTransformerAdaptor<T>(transformer));
    }

    public <T> DataTableType(Class<T> type, TableEntryTransformer<T> transformer) {
        this(type, (Type)TypeFactory.aListOf(type), new TableEntryTransformerAdaptor<T>(transformer));
    }

    public <T> DataTableType(Class<T> type, TableCellTransformer<T> transformer) {
        this(type, (Type)TypeFactory.aListOf((Type)TypeFactory.aListOf(type)), new TableCellTransformerAdaptor<T>(transformer));
    }

    public Object transform(List<List<String>> raw) {
        try {
            return this.transformer.transform(raw);
        }
        catch (Throwable throwable) {
            throw new CucumberDataTableException(String.format("'%s' could not transform%n%s", this.toCanonical(), DataTable.create(raw)), throwable);
        }
    }

    JavaType getTargetType() {
        return this.targetType;
    }

    String toCanonical() {
        return this.targetType.toCanonical();
    }

    Class<?> getElementType() {
        return this.elementType;
    }

    Class<?> getTransformerType() {
        return this.transformer.getOriginalTransformerType();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataTableType that = (DataTableType)o;
        return this.targetType.equals((Object)that.targetType);
    }

    public int hashCode() {
        return this.targetType.hashCode();
    }

    private static class TableTransformerAdaptor<T>
    implements RawTableTransformer<T> {
        private final TableTransformer<T> transformer;

        TableTransformerAdaptor(TableTransformer<T> transformer) {
            if (transformer == null) {
                throw new NullPointerException("transformer cannot be null");
            }
            this.transformer = transformer;
        }

        @Override
        public Class<?> getOriginalTransformerType() {
            return TableTransformer.class;
        }

        @Override
        public T transform(List<List<String>> raw) throws Throwable {
            return this.transformer.transform(DataTable.create(raw, CONVERSION_REQUIRED));
        }
    }

    private static class TableEntryTransformerAdaptor<T>
    implements RawTableTransformer<List<T>> {
        private final TableEntryTransformer<T> transformer;

        TableEntryTransformerAdaptor(TableEntryTransformer<T> transformer) {
            if (transformer == null) {
                throw new NullPointerException("transformer cannot be null");
            }
            this.transformer = transformer;
        }

        @Override
        public Class<?> getOriginalTransformerType() {
            return TableEntryTransformer.class;
        }

        @Override
        public List<T> transform(List<List<String>> raw) throws Throwable {
            DataTable table = DataTable.create(raw, CONVERSION_REQUIRED);
            ArrayList<T> list = new ArrayList<T>();
            for (Map<String, String> entry : table.asMaps()) {
                list.add(this.transformer.transform(entry));
            }
            return list;
        }
    }

    private static class TableRowTransformerAdaptor<T>
    implements RawTableTransformer<List<T>> {
        private final TableRowTransformer<T> transformer;

        TableRowTransformerAdaptor(TableRowTransformer<T> transformer) {
            if (transformer == null) {
                throw new NullPointerException("transformer cannot be null");
            }
            this.transformer = transformer;
        }

        @Override
        public Class<?> getOriginalTransformerType() {
            return TableRowTransformer.class;
        }

        @Override
        public List<T> transform(List<List<String>> raw) throws Throwable {
            ArrayList<T> list = new ArrayList<T>();
            for (List<String> tableRow : raw) {
                list.add(this.transformer.transform(tableRow));
            }
            return list;
        }
    }

    private static class TableCellTransformerAdaptor<T>
    implements RawTableTransformer<List<List<T>>> {
        private final TableCellTransformer<T> transformer;

        TableCellTransformerAdaptor(TableCellTransformer<T> transformer) {
            if (transformer == null) {
                throw new NullPointerException("transformer cannot be null");
            }
            this.transformer = transformer;
        }

        @Override
        public Class<?> getOriginalTransformerType() {
            return TableCellTransformer.class;
        }

        @Override
        public List<List<T>> transform(List<List<String>> raw) throws Throwable {
            ArrayList<List<T>> list = new ArrayList<List<T>>(raw.size());
            for (List<String> tableRow : raw) {
                ArrayList<T> row = new ArrayList<T>(tableRow.size());
                for (String entry : tableRow) {
                    row.add(this.transformer.transform(entry));
                }
                list.add(row);
            }
            return list;
        }
    }

    static interface RawTableTransformer<T> {
        public Class<?> getOriginalTransformerType();

        public T transform(List<List<String>> var1) throws Throwable;
    }
}

