/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.datatable.matchers;

import io.cucumber.datatable.DataTable;
import io.cucumber.datatable.DataTableDiff;
import io.cucumber.datatable.TableDiffer;
import org.apiguardian.api.API;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeDiagnosingMatcher;

@API(status=API.Status.STABLE)
public final class DataTableHasTheSameRowsAs
extends TypeSafeDiagnosingMatcher<DataTable> {
    private final DataTable expectedValue;
    private final boolean unordered;

    private DataTableHasTheSameRowsAs(DataTable expectedValue, boolean unordered) {
        this.expectedValue = expectedValue;
        this.unordered = unordered;
    }

    public void describeTo(Description description) {
        description.appendText("a datable with the same rows");
        if (this.unordered) {
            description.appendText(" in any order");
        }
    }

    protected boolean matchesSafely(DataTable item, Description description) {
        DataTableDiff diff;
        TableDiffer tableDiffer = new TableDiffer(this.expectedValue, item);
        DataTableDiff dataTableDiff = diff = this.unordered ? tableDiffer.calculateUnorderedDiffs() : tableDiffer.calculateDiffs();
        if (diff.isEmpty()) {
            return true;
        }
        description.appendText("the tables were different\n");
        description.appendText(diff.toString());
        return false;
    }

    public DataTableHasTheSameRowsAs inOrder() {
        return new DataTableHasTheSameRowsAs(this.expectedValue, false);
    }

    public static DataTableHasTheSameRowsAs hasTheSameRowsAs(DataTable operand) {
        return new DataTableHasTheSameRowsAs(operand, true);
    }
}

