/*
 * Decompiled with CFR 0.152.
 */
package cucumber.api.testng;

import cucumber.api.Result;
import cucumber.api.event.EventHandler;
import cucumber.api.event.EventListener;
import cucumber.api.event.EventPublisher;
import cucumber.api.event.TestCaseFinished;
import cucumber.runtime.CucumberException;

class TestCaseResultListener
implements EventListener {
    static final String UNDEFINED_MESSAGE = "There are undefined steps";
    private boolean strict;
    private Throwable error = null;
    private final EventHandler<TestCaseFinished> testCaseFinishedHandler = new EventHandler<TestCaseFinished>(){

        public void receive(TestCaseFinished event) {
            TestCaseResultListener.this.collectError(event.result);
        }
    };

    TestCaseResultListener(boolean strict) {
        this.strict = strict;
    }

    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(TestCaseFinished.class, this.testCaseFinishedHandler);
    }

    void collectError(Result result) {
        switch (result.getStatus()) {
            case FAILED: 
            case AMBIGUOUS: {
                this.error = result.getError();
                break;
            }
            case PENDING: {
                if (!this.strict) break;
                this.error = result.getError();
                break;
            }
            case UNDEFINED: {
                if (!this.strict) break;
                this.error = new CucumberException(UNDEFINED_MESSAGE);
                break;
            }
            case PASSED: 
            case SKIPPED: {
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected result status: " + result.getStatus());
            }
        }
    }

    boolean isPassed() {
        return this.error == null;
    }

    Throwable getError() {
        return this.error;
    }

    void startPickle() {
        this.error = null;
    }
}

