/*
 * Decompiled with CFR 0.152.
 */
package cucumber.api.testng;

import cucumber.api.Result;
import cucumber.api.event.EventHandler;
import cucumber.api.event.EventPublisher;
import cucumber.api.event.TestRunFinished;
import cucumber.api.event.TestStepFinished;
import cucumber.api.formatter.Formatter;
import cucumber.api.formatter.NiceAppendable;
import cucumber.runtime.Utils;
import org.testng.ITestResult;
import org.testng.Reporter;

class TestNGReporter
implements Formatter {
    private final NiceAppendable out;
    private final EventHandler<TestStepFinished> testStepFinishedHandler = new EventHandler<TestStepFinished>(){

        public void receive(TestStepFinished event) {
            if (!event.testStep.isHook()) {
                TestNGReporter.this.result(event.testStep.getStepText(), event.result);
            }
        }
    };
    private EventHandler<TestRunFinished> runFinishHandler = new EventHandler<TestRunFinished>(){

        public void receive(TestRunFinished event) {
            TestNGReporter.this.out.close();
        }
    };

    TestNGReporter(Appendable appendable) {
        this.out = new NiceAppendable(appendable);
    }

    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(TestStepFinished.class, this.testStepFinishedHandler);
        publisher.registerHandlerFor(TestRunFinished.class, this.runFinishHandler);
    }

    void uri(String uri) {
        String keyword = "Feature File";
        this.logDiv(keyword, uri, "featureFile");
    }

    private void result(String stepText, Result result) {
        this.logResult(stepText, result);
        ITestResult tr = Reporter.getCurrentTestResult();
        switch (result.getStatus()) {
            case PASSED: {
                break;
            }
            case FAILED: 
            case AMBIGUOUS: {
                tr.setThrowable(result.getError());
                tr.setStatus(2);
                break;
            }
            case SKIPPED: {
                tr.setThrowable(result.getError());
                tr.setStatus(3);
            }
            case UNDEFINED: 
            case PENDING: {
                tr.setThrowable(result.getError());
                tr.setStatus(2);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected result status: " + result.getStatus());
            }
        }
    }

    private void logResult(String stepText, Result result) {
        String timing = this.computeTiming(result);
        String format = "%s (%s%s)";
        String message = String.format(format, stepText, result.getStatus(), timing);
        this.logDiv(message, "result");
    }

    private String computeTiming(Result result) {
        String timing = "";
        if (result.getDuration() != null) {
            int duration = Math.round(result.getDuration() / 1000000000L);
            timing = " : " + duration + "s";
        }
        return timing;
    }

    private void logDiv(String message, String cssClassName) {
        String format = "<div \"%s\">%s</div>";
        String output = String.format(format, cssClassName, Utils.htmlEscape((String)message));
        Reporter.log((String)output);
    }

    private void logDiv(String message, String message2, String cssClassName) {
        this.logDiv(message + ": " + message2, cssClassName);
    }
}

