/*
 * Decompiled with CFR 0.152.
 */
package cucumber.api.testng;

import cucumber.api.Result;
import cucumber.api.event.EventHandler;
import cucumber.api.event.EventPublisher;
import cucumber.api.event.TestCaseFinished;
import cucumber.api.formatter.Formatter;
import cucumber.runtime.AmbiguousStepDefinitionsException;
import cucumber.runtime.CucumberException;

class FeatureResultListener
implements Formatter {
    static final String UNDEFINED_MESSAGE = "There are undefined steps";
    static final String PENDING_MESSAGE = "There are pending steps";
    private boolean strict;
    private Throwable error = null;
    private final EventHandler<TestCaseFinished> testCaseFinishedHandler = new EventHandler<TestCaseFinished>(){

        public void receive(TestCaseFinished event) {
            FeatureResultListener.this.collectError(event.result);
        }
    };

    FeatureResultListener(boolean strict) {
        this.strict = strict;
    }

    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(TestCaseFinished.class, this.testCaseFinishedHandler);
    }

    void collectError(Result result) {
        if (result.is(Result.Type.FAILED)) {
            if (this.error == null || this.isAmbiguousError(this.error) || this.isUndefinedError(this.error) || this.isPendingError(this.error)) {
                this.error = result.getError();
            }
        } else if (result.is(Result.Type.AMBIGUOUS)) {
            if (this.error == null || this.isUndefinedError(this.error) || this.isPendingError(this.error)) {
                this.error = result.getError();
            }
        } else if (result.is(Result.Type.PENDING) && this.strict) {
            if (this.error == null || this.isUndefinedError(this.error)) {
                this.error = new CucumberException(PENDING_MESSAGE);
            }
        } else if (result.is(Result.Type.UNDEFINED) && this.strict && this.error == null) {
            this.error = new CucumberException(UNDEFINED_MESSAGE);
        }
    }

    private boolean isPendingError(Throwable error) {
        return error instanceof CucumberException && error.getMessage().equals(PENDING_MESSAGE);
    }

    private boolean isUndefinedError(Throwable error) {
        return error instanceof CucumberException && error.getMessage().equals(UNDEFINED_MESSAGE);
    }

    private boolean isAmbiguousError(Throwable error) {
        return error instanceof AmbiguousStepDefinitionsException;
    }

    boolean isPassed() {
        return this.error == null;
    }

    Throwable getFirstError() {
        return this.error;
    }

    void startFeature() {
        this.error = null;
    }
}

