/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.spring;

import io.cucumber.core.backend.CucumberBackendException;
import io.cucumber.spring.CucumberScenarioScope;
import io.cucumber.spring.CucumberTestContext;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.function.Supplier;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.Scope;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.TestContextManager;

class TestContextAdaptor {
    private static final Object monitor = new Object();
    private final TestContextManager delegate;
    private final ConfigurableApplicationContext applicationContext;
    private final Deque<Runnable> stopInvocations = new ArrayDeque<Runnable>();
    private Object delegateTestInstance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static TestContextAdaptor create(Supplier<TestContextManager> testContextManagerSupplier, Collection<Class<?>> glueClasses) {
        Object object = monitor;
        synchronized (object) {
            TestContextManager delegate = testContextManagerSupplier.get();
            TestContext testContext = delegate.getTestContext();
            ConfigurableApplicationContext applicationContext = (ConfigurableApplicationContext)testContext.getApplicationContext();
            TestContextAdaptor.registerGlueCodeScope(applicationContext);
            TestContextAdaptor.registerStepClassBeanDefinitions(applicationContext.getBeanFactory(), glueClasses);
            return new TestContextAdaptor(delegate);
        }
    }

    TestContextAdaptor(TestContextManager delegate) {
        this.delegate = delegate;
        this.applicationContext = (ConfigurableApplicationContext)delegate.getTestContext().getApplicationContext();
    }

    final void start() {
        this.stopInvocations.push(this::notifyTestContextManagerAboutAfterTestClass);
        this.notifyContextManagerAboutBeforeTestClass();
        this.stopInvocations.push(this::stopCucumberTestContext);
        this.startCucumberTestContext();
        this.stopInvocations.push(this::disposeTestInstance);
        this.createAndPrepareTestInstance();
        this.stopInvocations.push(this::notifyTestContextManagerAboutAfterTestMethod);
        this.notifyTestContextManagerAboutBeforeTestMethod();
        this.stopInvocations.push(this::notifyTestContextManagerAboutAfterTestExecution);
        this.notifyTestContextManagerAboutBeforeExecution();
    }

    private void notifyContextManagerAboutBeforeTestClass() {
        try {
            this.delegate.beforeTestClass();
        }
        catch (Exception e) {
            throw new CucumberBackendException(e.getMessage(), (Throwable)e);
        }
    }

    private void startCucumberTestContext() {
        CucumberTestContext.getInstance().start();
    }

    private void createAndPrepareTestInstance() {
        try {
            Class beanClass = this.delegate.getTestContext().getTestClass();
            ConfigurableListableBeanFactory beanFactory = this.applicationContext.getBeanFactory();
            Object bean = beanFactory.autowire(beanClass, 3, false);
            this.delegate.prepareTestInstance(bean);
            CucumberTestContext scenarioScope = CucumberTestContext.getInstance();
            scenarioScope.put(beanClass.getName(), bean);
            this.delegateTestInstance = bean;
        }
        catch (Exception e) {
            throw new CucumberBackendException(e.getMessage(), (Throwable)e);
        }
    }

    private void notifyTestContextManagerAboutBeforeTestMethod() {
        try {
            Method dummyMethod = this.getDummyMethod();
            this.delegate.beforeTestMethod(this.delegateTestInstance, dummyMethod);
        }
        catch (Exception e) {
            throw new CucumberBackendException(e.getMessage(), (Throwable)e);
        }
    }

    private static void registerGlueCodeScope(ConfigurableApplicationContext context) {
        while (context != null) {
            ConfigurableListableBeanFactory beanFactory = context.getBeanFactory();
            Scope registeredScope = beanFactory.getRegisteredScope("cucumber-glue");
            if (registeredScope == null) {
                beanFactory.registerScope("cucumber-glue", (Scope)new CucumberScenarioScope());
            }
            context = (ConfigurableApplicationContext)context.getParent();
        }
    }

    private void notifyTestContextManagerAboutBeforeExecution() {
        try {
            this.delegate.beforeTestExecution(this.delegateTestInstance, this.getDummyMethod());
        }
        catch (Exception e) {
            throw new CucumberBackendException(e.getMessage(), (Throwable)e);
        }
    }

    private static void registerStepClassBeanDefinitions(ConfigurableListableBeanFactory beanFactory, Collection<Class<?>> glueClasses) {
        BeanDefinitionRegistry registry = (BeanDefinitionRegistry)beanFactory;
        for (Class<?> glue : glueClasses) {
            TestContextAdaptor.registerStepClassBeanDefinition(registry, glue);
        }
    }

    private static void registerStepClassBeanDefinition(BeanDefinitionRegistry registry, Class<?> glueClass) {
        String beanName = glueClass.getName();
        if (registry.containsBeanDefinition(beanName)) {
            return;
        }
        registry.registerBeanDefinition(beanName, (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(glueClass).setScope("cucumber-glue").getBeanDefinition());
    }

    final void stop() {
        CucumberBackendException lastException = null;
        for (Runnable stopInvocation : this.stopInvocations) {
            try {
                stopInvocation.run();
            }
            catch (CucumberBackendException e) {
                if (lastException != null) {
                    e.addSuppressed((Throwable)lastException);
                }
                lastException = e;
            }
        }
        if (lastException != null) {
            throw lastException;
        }
    }

    private void notifyTestContextManagerAboutAfterTestClass() {
        try {
            this.delegate.afterTestClass();
        }
        catch (Exception e) {
            throw new CucumberBackendException(e.getMessage(), (Throwable)e);
        }
    }

    private void stopCucumberTestContext() {
        CucumberTestContext.getInstance().stop();
    }

    private void disposeTestInstance() {
        this.delegateTestInstance = null;
    }

    private void notifyTestContextManagerAboutAfterTestMethod() {
        try {
            Object delegateTestInstance = this.delegate.getTestContext().getTestInstance();
            this.delegate.afterTestMethod(delegateTestInstance, this.getDummyMethod(), null);
        }
        catch (Exception e) {
            throw new CucumberBackendException(e.getMessage(), (Throwable)e);
        }
    }

    private void notifyTestContextManagerAboutAfterTestExecution() {
        try {
            Object delegateTestInstance = this.delegate.getTestContext().getTestInstance();
            this.delegate.afterTestExecution(delegateTestInstance, this.getDummyMethod(), null);
        }
        catch (Exception e) {
            throw new CucumberBackendException(e.getMessage(), (Throwable)e);
        }
    }

    final <T> T getInstance(Class<T> type) {
        return (T)this.applicationContext.getBean(type);
    }

    private Method getDummyMethod() {
        try {
            return TestContextAdaptor.class.getMethod("cucumberDoesNotHaveASingleTestMethod", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public void cucumberDoesNotHaveASingleTestMethod() {
    }
}

