/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.spring;

import io.cucumber.core.backend.CucumberBackendException;
import io.cucumber.core.backend.ObjectFactory;
import io.cucumber.spring.CucumberContextConfiguration;
import io.cucumber.spring.TestContextAdaptor;
import java.lang.annotation.Annotation;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.apiguardian.api.API;
import org.springframework.beans.BeansException;
import org.springframework.stereotype.Component;
import org.springframework.test.context.TestContextManager;

@API(status=API.Status.STABLE)
public final class SpringFactory
implements ObjectFactory {
    private final Collection<Class<?>> stepClasses = new HashSet();
    private Class<?> withCucumberContextConfiguration = null;
    private TestContextAdaptor testContextAdaptor;

    public boolean addClass(Class<?> stepClass) {
        if (this.stepClasses.contains(stepClass)) {
            return true;
        }
        SpringFactory.checkNoComponentAnnotations(stepClass);
        if (SpringFactory.hasCucumberContextConfiguration(stepClass)) {
            this.checkOnlyOneClassHasCucumberContextConfiguration(stepClass);
            this.withCucumberContextConfiguration = stepClass;
        }
        this.stepClasses.add(stepClass);
        return true;
    }

    private static void checkNoComponentAnnotations(Class<?> type) {
        for (Annotation annotation : type.getAnnotations()) {
            if (!SpringFactory.hasComponentAnnotation(annotation)) continue;
            throw new CucumberBackendException(String.format("Glue class %1$s was annotated with @%2$s; marking it as a candidate for auto-detection by Spring. Glue classes are detected and registered by Cucumber. Auto-detection of glue classes by spring may lead to duplicate bean definitions. Please remove the @%2$s annotation", type.getName(), annotation.annotationType().getSimpleName()));
        }
    }

    private static boolean hasCucumberContextConfiguration(Class<?> stepClass) {
        return stepClass.getAnnotation(CucumberContextConfiguration.class) != null;
    }

    private void checkOnlyOneClassHasCucumberContextConfiguration(Class<?> stepClass) {
        if (this.withCucumberContextConfiguration != null) {
            throw new CucumberBackendException(String.format("Glue class %1$s and %2$s are both annotated with @CucumberContextConfiguration.\nPlease ensure only one class configures the spring context", stepClass, this.withCucumberContextConfiguration));
        }
    }

    public void start() {
        if (this.withCucumberContextConfiguration == null) {
            throw new CucumberBackendException("Please annotate a glue class with some context configuration.\n\nFor example:\n\n   @CucumberContextConfiguration\n   @SpringBootTest(classes = TestConfig.class)\n   public class CucumberSpringConfiguration { }\nOr: \n\n   @CucumberContextConfiguration\n   @ContextConfiguration( ... )\n   public class CucumberSpringConfiguration { }");
        }
        TestContextManager testContextManager = new TestContextManager(this.withCucumberContextConfiguration);
        this.testContextAdaptor = TestContextAdaptor.createTestContextManagerAdaptor(testContextManager, this.stepClasses);
        this.testContextAdaptor.start();
    }

    public void stop() {
        if (this.testContextAdaptor != null) {
            this.testContextAdaptor.stop();
        }
    }

    public <T> T getInstance(Class<T> type) {
        try {
            return this.testContextAdaptor.getInstance(type);
        }
        catch (BeansException e) {
            throw new CucumberBackendException(e.getMessage(), (Throwable)e);
        }
    }

    private static boolean hasComponentAnnotation(Annotation annotation) {
        return SpringFactory.hasAnnotation(annotation, Collections.singleton(Component.class));
    }

    private static boolean hasAnnotation(Annotation annotation, Collection<Class<? extends Annotation>> desired) {
        HashSet<Class> seen = new HashSet<Class>();
        ArrayDeque<Class<? extends Annotation>> toCheck = new ArrayDeque<Class<? extends Annotation>>();
        toCheck.add(annotation.annotationType());
        while (!toCheck.isEmpty()) {
            Class annotationType = (Class)toCheck.pop();
            if (desired.contains(annotationType)) {
                return true;
            }
            seen.add(annotationType);
            for (Annotation annotationTypesAnnotations : annotationType.getAnnotations()) {
                if (seen.contains(annotationTypesAnnotations.annotationType())) continue;
                toCheck.add(annotationTypesAnnotations.annotationType());
            }
        }
        return false;
    }
}

