/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.spring;

import java.util.Set;
import org.springframework.beans.BeanUtils;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.test.context.BootstrapContext;
import org.springframework.test.context.BootstrapWith;
import org.springframework.test.context.CacheAwareContextLoaderDelegate;
import org.springframework.test.context.TestContextBootstrapper;
import org.springframework.test.context.cache.ContextCache;
import org.springframework.test.context.cache.DefaultCacheAwareContextLoaderDelegate;
import org.springframework.test.context.cache.DefaultContextCache;
import org.springframework.test.context.support.DefaultBootstrapContext;
import org.springframework.util.ClassUtils;

abstract class FixBootstrapUtils {
    private static ThreadLocal<ContextCache> contextCache = ThreadLocal.withInitial(DefaultContextCache::new);
    private static final String DEFAULT_TEST_CONTEXT_BOOTSTRAPPER_CLASS_NAME = "org.springframework.test.context.support.DefaultTestContextBootstrapper";
    private static final String DEFAULT_WEB_TEST_CONTEXT_BOOTSTRAPPER_CLASS_NAME = "org.springframework.test.context.web.WebTestContextBootstrapper";
    private static final String WEB_APP_CONFIGURATION_ANNOTATION_CLASS_NAME = "org.springframework.test.context.web.WebAppConfiguration";

    FixBootstrapUtils() {
    }

    static BootstrapContext createBootstrapContext(Class<?> testClass) {
        DefaultCacheAwareContextLoaderDelegate contextLoader = new DefaultCacheAwareContextLoaderDelegate(contextCache.get());
        return new DefaultBootstrapContext(testClass, (CacheAwareContextLoaderDelegate)contextLoader);
    }

    static TestContextBootstrapper resolveTestContextBootstrapper(BootstrapContext bootstrapContext) {
        Class testClass = bootstrapContext.getTestClass();
        Class<?> clazz = null;
        try {
            clazz = FixBootstrapUtils.resolveExplicitTestContextBootstrapper(testClass);
            if (clazz == null) {
                clazz = FixBootstrapUtils.resolveDefaultTestContextBootstrapper(testClass);
            }
            TestContextBootstrapper testContextBootstrapper = (TestContextBootstrapper)BeanUtils.instantiateClass(clazz, TestContextBootstrapper.class);
            testContextBootstrapper.setBootstrapContext(bootstrapContext);
            return testContextBootstrapper;
        }
        catch (IllegalStateException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new IllegalStateException("Could not load TestContextBootstrapper [" + clazz + "]. Specify @BootstrapWith's 'value' attribute or make the default bootstrapper class available.", ex);
        }
    }

    private static Class<?> resolveExplicitTestContextBootstrapper(Class<?> testClass) {
        Set annotations = AnnotatedElementUtils.findAllMergedAnnotations(testClass, BootstrapWith.class);
        if (annotations.size() < 1) {
            return null;
        }
        if (annotations.size() > 1) {
            throw new IllegalStateException(String.format("Configuration error: found multiple declarations of @BootstrapWith for test class [%s]: %s", testClass.getName(), annotations));
        }
        return ((BootstrapWith)annotations.iterator().next()).value();
    }

    private static Class<?> resolveDefaultTestContextBootstrapper(Class<?> testClass) throws Exception {
        ClassLoader classLoader = FixBootstrapUtils.class.getClassLoader();
        AnnotationAttributes attributes = AnnotatedElementUtils.findMergedAnnotationAttributes(testClass, (String)WEB_APP_CONFIGURATION_ANNOTATION_CLASS_NAME, (boolean)false, (boolean)false);
        if (attributes != null) {
            return ClassUtils.forName((String)DEFAULT_WEB_TEST_CONTEXT_BOOTSTRAPPER_CLASS_NAME, (ClassLoader)classLoader);
        }
        return ClassUtils.forName((String)DEFAULT_TEST_CONTEXT_BOOTSTRAPPER_CLASS_NAME, (ClassLoader)classLoader);
    }
}

