/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.spring;

import io.cucumber.core.backend.CucumberBackendException;
import io.cucumber.core.backend.ObjectFactory;
import io.cucumber.spring.FixBootstrapUtils;
import io.cucumber.spring.GlueCodeContext;
import io.cucumber.spring.GlueCodeScope;
import java.lang.annotation.Annotation;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.apiguardian.api.API;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.Scope;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.test.context.BootstrapWith;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.ContextHierarchy;
import org.springframework.test.context.TestContextManager;

@API(status=API.Status.STABLE)
public final class SpringFactory
implements ObjectFactory {
    private ConfigurableListableBeanFactory beanFactory;
    private CucumberTestContextManager testContextManager;
    private final Collection<Class<?>> stepClasses = new HashSet();
    private Class<?> stepClassWithSpringContext = null;

    public boolean addClass(Class<?> stepClass) {
        if (!this.stepClasses.contains(stepClass)) {
            SpringFactory.checkNoComponentAnnotations(stepClass);
            if (SpringFactory.dependsOnSpringContext(stepClass)) {
                if (this.stepClassWithSpringContext != null) {
                    throw new CucumberBackendException(String.format("Glue class %1$s and %2$s both attempt to configure the spring context. Please ensure only one glue class configures the spring context", stepClass, this.stepClassWithSpringContext));
                }
                this.stepClassWithSpringContext = stepClass;
            }
            this.stepClasses.add(stepClass);
        }
        return true;
    }

    private static void checkNoComponentAnnotations(Class<?> type) {
        for (Annotation annotation : type.getAnnotations()) {
            if (!SpringFactory.hasComponentAnnotation(annotation)) continue;
            throw new CucumberBackendException(String.format("Glue class %1$s was annotated with @%2$s; marking it as a candidate for auto-detection by Spring. Glue classes are detected and registered by Cucumber. Auto-detection of glue classes by spring may lead to duplicate bean definitions. Please remove the @%2$s annotation", type.getName(), annotation.annotationType().getSimpleName()));
        }
    }

    private static boolean hasComponentAnnotation(Annotation annotation) {
        return SpringFactory.hasAnnotation(annotation, Collections.singleton(Component.class));
    }

    private static boolean hasAnnotation(Annotation annotation, Collection<Class<? extends Annotation>> desired) {
        HashSet<Class> seen = new HashSet<Class>();
        ArrayDeque<Class<? extends Annotation>> toCheck = new ArrayDeque<Class<? extends Annotation>>();
        toCheck.add(annotation.annotationType());
        while (!toCheck.isEmpty()) {
            Class annotationType = (Class)toCheck.pop();
            if (desired.contains(annotationType)) {
                return true;
            }
            seen.add(annotationType);
            for (Annotation annotationTypesAnnotations : annotationType.getAnnotations()) {
                if (seen.contains(annotationTypesAnnotations.annotationType())) continue;
                toCheck.add(annotationTypesAnnotations.annotationType());
            }
        }
        return false;
    }

    public void start() {
        if (this.stepClassWithSpringContext != null) {
            this.testContextManager = new CucumberTestContextManager(this.stepClassWithSpringContext);
        } else if (this.beanFactory == null) {
            this.beanFactory = this.createFallbackContext();
        }
        this.notifyContextManagerAboutTestClassStarted();
        if (this.beanFactory == null || this.isNewContextCreated()) {
            this.beanFactory = this.testContextManager.getBeanFactory();
            for (Class<?> stepClass : this.stepClasses) {
                this.registerStepClassBeanDefinition(this.beanFactory, stepClass);
            }
        }
        GlueCodeContext.getInstance().start();
    }

    private ConfigurableListableBeanFactory createFallbackContext() {
        Object applicationContext = this.getClass().getClassLoader().getResource("cucumber.xml") != null ? new ClassPathXmlApplicationContext("cucumber.xml") : new GenericApplicationContext();
        applicationContext.registerShutdownHook();
        ConfigurableListableBeanFactory beanFactory = applicationContext.getBeanFactory();
        beanFactory.registerScope("cucumber-glue", (Scope)new GlueCodeScope());
        for (Class<?> stepClass : this.stepClasses) {
            this.registerStepClassBeanDefinition(beanFactory, stepClass);
        }
        return beanFactory;
    }

    private void notifyContextManagerAboutTestClassStarted() {
        if (this.testContextManager != null) {
            try {
                this.testContextManager.beforeTestClass();
            }
            catch (Exception e) {
                throw new CucumberBackendException(e.getMessage(), (Throwable)e);
            }
        }
    }

    private boolean isNewContextCreated() {
        if (this.testContextManager == null) {
            return false;
        }
        return !this.beanFactory.equals(this.testContextManager.getBeanFactory());
    }

    private void registerStepClassBeanDefinition(ConfigurableListableBeanFactory beanFactory, Class<?> stepClass) {
        BeanDefinitionRegistry registry = (BeanDefinitionRegistry)beanFactory;
        AbstractBeanDefinition beanDefinition = BeanDefinitionBuilder.genericBeanDefinition(stepClass).setScope("cucumber-glue").getBeanDefinition();
        registry.registerBeanDefinition(stepClass.getName(), (BeanDefinition)beanDefinition);
    }

    public void stop() {
        this.notifyContextManagerAboutTestClassFinished();
        GlueCodeContext.getInstance().stop();
    }

    private void notifyContextManagerAboutTestClassFinished() {
        if (this.testContextManager != null) {
            try {
                this.testContextManager.afterTestClass();
            }
            catch (Exception e) {
                throw new CucumberBackendException(e.getMessage(), (Throwable)e);
            }
        }
    }

    public <T> T getInstance(Class<T> type) {
        try {
            return (T)this.beanFactory.getBean(type);
        }
        catch (BeansException e) {
            throw new CucumberBackendException(e.getMessage(), (Throwable)e);
        }
    }

    private static boolean dependsOnSpringContext(Class<?> type) {
        for (Annotation annotation : type.getAnnotations()) {
            if (!SpringFactory.annotatedWithSupportedSpringRootTestAnnotations(annotation)) continue;
            return true;
        }
        return false;
    }

    private static boolean annotatedWithSupportedSpringRootTestAnnotations(Annotation type) {
        return SpringFactory.hasAnnotation(type, Arrays.asList(ContextConfiguration.class, ContextHierarchy.class, BootstrapWith.class));
    }

    static class CucumberTestContextManager
    extends TestContextManager {
        CucumberTestContextManager(Class<?> testClass) {
            super(FixBootstrapUtils.resolveTestContextBootstrapper(FixBootstrapUtils.createBootstrapContext(testClass)));
            this.registerGlueCodeScope(this.getContext());
        }

        ConfigurableListableBeanFactory getBeanFactory() {
            return this.getContext().getBeanFactory();
        }

        private ConfigurableApplicationContext getContext() {
            return (ConfigurableApplicationContext)this.getTestContext().getApplicationContext();
        }

        private void registerGlueCodeScope(ConfigurableApplicationContext context) {
            do {
                context.getBeanFactory().registerScope("cucumber-glue", (Scope)new GlueCodeScope());
            } while ((context = (ConfigurableApplicationContext)context.getParent()) != null);
        }
    }
}

