/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.junit;

import io.cucumber.core.eventbus.EventBus;
import io.cucumber.core.feature.FeatureParser;
import io.cucumber.core.filter.Filters;
import io.cucumber.core.gherkin.Feature;
import io.cucumber.core.logging.Logger;
import io.cucumber.core.logging.LoggerFactory;
import io.cucumber.core.options.CucumberOptionsAnnotationParser;
import io.cucumber.core.options.CucumberProperties;
import io.cucumber.core.options.CucumberPropertiesParser;
import io.cucumber.core.options.RuntimeOptions;
import io.cucumber.core.plugin.Options;
import io.cucumber.core.plugin.PluginFactory;
import io.cucumber.core.plugin.Plugins;
import io.cucumber.core.resource.ClassLoaders;
import io.cucumber.core.runtime.BackendServiceLoader;
import io.cucumber.core.runtime.BackendSupplier;
import io.cucumber.core.runtime.CucumberExecutionContext;
import io.cucumber.core.runtime.ExitStatus;
import io.cucumber.core.runtime.FeaturePathFeatureSupplier;
import io.cucumber.core.runtime.ObjectFactoryServiceLoader;
import io.cucumber.core.runtime.ObjectFactorySupplier;
import io.cucumber.core.runtime.RunnerSupplier;
import io.cucumber.core.runtime.ScanningTypeRegistryConfigurerSupplier;
import io.cucumber.core.runtime.ThreadLocalObjectFactorySupplier;
import io.cucumber.core.runtime.ThreadLocalRunnerSupplier;
import io.cucumber.core.runtime.TimeServiceEventBus;
import io.cucumber.core.runtime.TypeRegistryConfigurerSupplier;
import io.cucumber.junit.Assertions;
import io.cucumber.junit.FeatureRunner;
import io.cucumber.junit.JUnitCucumberOptionsProvider;
import io.cucumber.junit.JUnitOptions;
import io.cucumber.junit.JUnitOptionsParser;
import io.cucumber.plugin.Plugin;
import io.cucumber.plugin.event.EventPublisher;
import java.time.Clock;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerScheduler;
import org.junit.runners.model.Statement;

@API(status=API.Status.STABLE)
public final class Cucumber
extends ParentRunner<ParentRunner<?>> {
    private static final Logger log = LoggerFactory.getLogger(Cucumber.class);
    private final List<ParentRunner<?>> children;
    private final EventBus bus;
    private final List<Feature> features;
    private final Plugins plugins;
    private final CucumberExecutionContext context;
    private boolean multiThreadingAssumed = false;

    public Cucumber(Class<?> clazz) throws InitializationError {
        super(clazz);
        Assertions.assertNoCucumberAnnotatedMethods(clazz);
        RuntimeOptions propertiesFileOptions = new CucumberPropertiesParser().parse(CucumberProperties.fromPropertiesFile()).build();
        RuntimeOptions annotationOptions = new CucumberOptionsAnnotationParser().withOptionsProvider((CucumberOptionsAnnotationParser.OptionsProvider)new JUnitCucumberOptionsProvider()).parse(clazz).build(propertiesFileOptions);
        RuntimeOptions environmentOptions = new CucumberPropertiesParser().parse(CucumberProperties.fromEnvironment()).build(annotationOptions);
        RuntimeOptions runtimeOptions = new CucumberPropertiesParser().parse(CucumberProperties.fromSystemProperties()).build(environmentOptions);
        JUnitOptions junitPropertiesFileOptions = new JUnitOptionsParser().parse(CucumberProperties.fromPropertiesFile()).build();
        JUnitOptions junitAnnotationOptions = new JUnitOptionsParser().parse(clazz).build(junitPropertiesFileOptions);
        JUnitOptions junitEnvironmentOptions = new JUnitOptionsParser().parse(CucumberProperties.fromEnvironment()).build(junitAnnotationOptions);
        JUnitOptions junitOptions = new JUnitOptionsParser().parse(CucumberProperties.fromSystemProperties()).build(junitEnvironmentOptions);
        this.bus = new TimeServiceEventBus(Clock.systemUTC(), UUID::randomUUID);
        FeatureParser parser = new FeatureParser(() -> ((EventBus)this.bus).generateId());
        Supplier<ClassLoader> classLoader = ClassLoaders::getDefaultClassLoader;
        FeaturePathFeatureSupplier featureSupplier = new FeaturePathFeatureSupplier(classLoader, (io.cucumber.core.feature.Options)runtimeOptions, parser);
        this.features = featureSupplier.get();
        this.plugins = new Plugins(new PluginFactory(), (Options)runtimeOptions);
        ExitStatus exitStatus = new ExitStatus((Options)runtimeOptions);
        this.plugins.addPlugin((Plugin)exitStatus);
        ObjectFactoryServiceLoader objectFactoryServiceLoader = new ObjectFactoryServiceLoader((io.cucumber.core.backend.Options)runtimeOptions);
        ThreadLocalObjectFactorySupplier objectFactorySupplier = new ThreadLocalObjectFactorySupplier(objectFactoryServiceLoader);
        BackendServiceLoader backendSupplier = new BackendServiceLoader(clazz::getClassLoader, (ObjectFactorySupplier)objectFactorySupplier);
        ScanningTypeRegistryConfigurerSupplier typeRegistryConfigurerSupplier = new ScanningTypeRegistryConfigurerSupplier(classLoader, (io.cucumber.core.runner.Options)runtimeOptions);
        ThreadLocalRunnerSupplier runnerSupplier = new ThreadLocalRunnerSupplier((io.cucumber.core.runner.Options)runtimeOptions, this.bus, (BackendSupplier)backendSupplier, (ObjectFactorySupplier)objectFactorySupplier, (TypeRegistryConfigurerSupplier)typeRegistryConfigurerSupplier);
        this.context = new CucumberExecutionContext(this.bus, exitStatus, (RunnerSupplier)runnerSupplier);
        Filters filters = new Filters((io.cucumber.core.filter.Options)runtimeOptions);
        this.children = this.features.stream().map(arg_0 -> Cucumber.lambda$new$0((Predicate)filters, runnerSupplier, junitOptions, arg_0)).filter(runner -> !runner.isEmpty()).collect(Collectors.toList());
    }

    protected List<ParentRunner<?>> getChildren() {
        return this.children;
    }

    protected Description describeChild(ParentRunner<?> child) {
        return child.getDescription();
    }

    protected void runChild(ParentRunner<?> child, RunNotifier notifier) {
        child.run(notifier);
    }

    protected Statement childrenInvoker(RunNotifier notifier) {
        Statement runFeatures = super.childrenInvoker(notifier);
        return new RunCucumber(runFeatures);
    }

    public void setScheduler(RunnerScheduler scheduler) {
        super.setScheduler(scheduler);
        this.multiThreadingAssumed = true;
    }

    private static /* synthetic */ FeatureRunner lambda$new$0(Predicate filters, ThreadLocalRunnerSupplier runnerSupplier, JUnitOptions junitOptions, Feature feature) {
        return FeatureRunner.create(feature, filters, (RunnerSupplier)runnerSupplier, junitOptions);
    }

    class RunCucumber
    extends Statement {
        private final Statement runFeatures;

        RunCucumber(Statement runFeatures) {
            this.runFeatures = runFeatures;
        }

        public void evaluate() throws Throwable {
            if (Cucumber.this.multiThreadingAssumed) {
                Cucumber.this.plugins.setSerialEventBusOnEventListenerPlugins((EventPublisher)Cucumber.this.bus);
            } else {
                Cucumber.this.plugins.setEventBusOnEventListenerPlugins((EventPublisher)Cucumber.this.bus);
            }
            Cucumber.this.context.startTestRun();
            Cucumber.this.features.forEach(arg_0 -> ((CucumberExecutionContext)Cucumber.this.context).beforeFeature(arg_0));
            try {
                this.runFeatures.evaluate();
            }
            finally {
                Cucumber.this.context.finishTestRun();
            }
        }
    }
}

