/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.junit;

import cucumber.runtime.CucumberException;
import cucumber.util.FixJava;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

public class JUnitOptions {
    private static final String OPTIONS_RESOURCE = "/cucumber/api/junit/OPTIONS.txt";
    private static String optionsText;
    private boolean filenameCompatibleNames = false;
    private boolean stepNotifications = false;

    public JUnitOptions(List<String> argv) {
        argv = new ArrayList<String>(argv);
        this.parse(argv);
    }

    private void parse(List<String> args) {
        while (!args.isEmpty()) {
            String arg = args.remove(0).trim();
            if (arg.equals("--help") || arg.equals("-h")) {
                this.printOptions();
                System.exit(0);
                continue;
            }
            if (arg.equals("--no-filename-compatible-names") || arg.equals("--filename-compatible-names")) {
                this.filenameCompatibleNames = !arg.startsWith("--no-");
                continue;
            }
            if (arg.equals("--no-step-notifications") || arg.equals("--step-notifications")) {
                this.stepNotifications = !arg.startsWith("--no-");
                continue;
            }
            this.printOptions();
            throw new CucumberException("Unknown option: " + arg);
        }
    }

    boolean filenameCompatibleNames() {
        return this.filenameCompatibleNames;
    }

    public boolean stepNotifications() {
        return this.stepNotifications;
    }

    private void printOptions() {
        JUnitOptions.loadUsageTextIfNeeded();
        System.out.println(optionsText);
    }

    private static void loadUsageTextIfNeeded() {
        if (optionsText == null) {
            try {
                InputStreamReader reader = new InputStreamReader(FixJava.class.getResourceAsStream(OPTIONS_RESOURCE), "UTF-8");
                optionsText = FixJava.readReader((Reader)reader);
            }
            catch (Exception e) {
                optionsText = "Could not load usage text: " + e.toString();
            }
        }
    }
}

