/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.junit.platform.engine;

import io.cucumber.junit.platform.engine.CucumberConfiguration;
import io.cucumber.junit.platform.engine.CucumberEngineExecutionContext;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.EngineDescriptor;
import org.junit.platform.engine.support.hierarchical.Node;

class CucumberEngineDescriptor
extends EngineDescriptor
implements Node<CucumberEngineExecutionContext> {
    static final String ENGINE_ID = "cucumber";
    private final CucumberConfiguration configuration;
    private final TestSource source;

    CucumberEngineDescriptor(UniqueId uniqueId, CucumberConfiguration configuration) {
        this(uniqueId, configuration, null);
    }

    CucumberEngineDescriptor(UniqueId uniqueId, CucumberConfiguration configuration, TestSource source) {
        super(uniqueId, "Cucumber");
        this.configuration = Objects.requireNonNull(configuration);
        this.source = source;
    }

    public CucumberConfiguration getConfiguration() {
        return this.configuration;
    }

    public Optional<TestSource> getSource() {
        return Optional.ofNullable(this.source);
    }

    public CucumberEngineExecutionContext prepare(CucumberEngineExecutionContext context) {
        return this.ifChildren(context, CucumberEngineExecutionContext::startTestRun);
    }

    public CucumberEngineExecutionContext before(CucumberEngineExecutionContext context) {
        return this.ifChildren(context, CucumberEngineExecutionContext::runBeforeAllHooks);
    }

    public void after(CucumberEngineExecutionContext context) {
        this.ifChildren(context, CucumberEngineExecutionContext::runAfterAllHooks);
    }

    public void cleanUp(CucumberEngineExecutionContext context) {
        this.ifChildren(context, CucumberEngineExecutionContext::finishTestRun);
    }

    private CucumberEngineExecutionContext ifChildren(CucumberEngineExecutionContext context, Consumer<CucumberEngineExecutionContext> action) {
        if (!this.getChildren().isEmpty()) {
            action.accept(context);
        }
        return context;
    }
}

