/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.junit.platform.engine;

import io.cucumber.core.gherkin.Feature;
import io.cucumber.junit.platform.engine.CucumberEngineExecutionContext;
import java.util.ArrayList;
import java.util.function.Predicate;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.AbstractTestDescriptor;
import org.junit.platform.engine.support.hierarchical.Node;

class FeatureDescriptor
extends AbstractTestDescriptor
implements Node<CucumberEngineExecutionContext> {
    private final Feature feature;

    FeatureDescriptor(UniqueId uniqueId, String name, TestSource source, Feature feature) {
        super(uniqueId, name, source);
        this.feature = feature;
    }

    Feature getFeature() {
        return this.feature;
    }

    private static void pruneRecursively(TestDescriptor descriptor, Predicate<TestDescriptor> toKeep) {
        if (!toKeep.test(descriptor)) {
            if (descriptor.isTest()) {
                descriptor.removeFromHierarchy();
            }
            ArrayList children = new ArrayList(descriptor.getChildren());
            children.forEach(child -> FeatureDescriptor.pruneRecursively(child, toKeep));
        }
    }

    void prune(Predicate<TestDescriptor> toKeep) {
        FeatureDescriptor.pruneRecursively((TestDescriptor)this, toKeep);
    }

    public CucumberEngineExecutionContext prepare(CucumberEngineExecutionContext context) {
        context.beforeFeature(this.feature);
        return context;
    }

    public TestDescriptor.Type getType() {
        return TestDescriptor.Type.CONTAINER;
    }
}

