/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.junit.platform.engine;

import io.cucumber.core.gherkin.Pickle;
import io.cucumber.core.resource.ClasspathSupport;
import io.cucumber.junit.platform.engine.CucumberEngineExecutionContext;
import io.cucumber.tagexpressions.Expression;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.platform.engine.ConfigurationParameters;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.TestTag;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.config.PrefixedConfigurationParameters;
import org.junit.platform.engine.support.descriptor.AbstractTestDescriptor;
import org.junit.platform.engine.support.descriptor.ClasspathResourceSource;
import org.junit.platform.engine.support.hierarchical.ExclusiveResource;
import org.junit.platform.engine.support.hierarchical.Node;

class PickleDescriptor
extends AbstractTestDescriptor
implements Node<CucumberEngineExecutionContext> {
    private final Pickle pickleEvent;
    private final Set<TestTag> tags;
    private final Set<ExclusiveResource> exclusiveResources = new LinkedHashSet<ExclusiveResource>(0);

    PickleDescriptor(ConfigurationParameters parameters, UniqueId uniqueId, String name, TestSource source, Pickle pickleEvent) {
        super(uniqueId, name, source);
        this.pickleEvent = pickleEvent;
        this.tags = this.getTags(pickleEvent);
        this.tags.forEach(tag -> {
            ExclusiveResourceOptions exclusiveResourceOptions = new ExclusiveResourceOptions(parameters, (TestTag)tag);
            exclusiveResourceOptions.exclusiveReadWriteResource().map(resource -> new ExclusiveResource(resource, ExclusiveResource.LockMode.READ_WRITE)).forEach(this.exclusiveResources::add);
            exclusiveResourceOptions.exclusiveReadResource().map(resource -> new ExclusiveResource(resource, ExclusiveResource.LockMode.READ)).forEach(this.exclusiveResources::add);
        });
    }

    private Set<TestTag> getTags(Pickle pickleEvent) {
        return pickleEvent.getTags().stream().map(tag -> tag.substring(1)).filter(TestTag::isValid).map(TestTag::create).collect(Collectors.collectingAndThen(Collectors.toCollection(LinkedHashSet::new), Collections::unmodifiableSet));
    }

    public TestDescriptor.Type getType() {
        return TestDescriptor.Type.TEST;
    }

    public Node.SkipResult shouldBeSkipped(CucumberEngineExecutionContext context) {
        List tags = this.pickleEvent.getTags();
        Expression expression = context.getOptions().tagFilter();
        if (expression.evaluate(tags)) {
            return Node.SkipResult.doNotSkip();
        }
        return Node.SkipResult.skip((String)("'cucumber.filter.tags=" + expression + "' did not match this scenario"));
    }

    public CucumberEngineExecutionContext execute(CucumberEngineExecutionContext context, Node.DynamicTestExecutor dynamicTestExecutor) {
        context.runTestCase(this.pickleEvent);
        return context;
    }

    public Set<ExclusiveResource> getExclusiveResources() {
        return this.exclusiveResources;
    }

    public Set<TestTag> getTags() {
        return this.tags;
    }

    Optional<String> getPackage() {
        return this.getSource().filter(ClasspathResourceSource.class::isInstance).map(ClasspathResourceSource.class::cast).map(ClasspathResourceSource::getClasspathResourceName).map(ClasspathSupport::packageNameOfResource);
    }

    private static final class ExclusiveResourceOptions {
        private final ConfigurationParameters parameters;

        ExclusiveResourceOptions(ConfigurationParameters parameters, TestTag tag) {
            this.parameters = new PrefixedConfigurationParameters(parameters, "cucumber.execution.exclusive-resources." + tag.getName());
        }

        public Stream<String> exclusiveReadWriteResource() {
            return this.parameters.get(".read-write", s -> Arrays.stream(s.split(",")).map(String::trim)).orElse(Stream.empty());
        }

        public Stream<String> exclusiveReadResource() {
            return this.parameters.get(".read", s -> Arrays.stream(s.split(",")).map(String::trim)).orElse(Stream.empty());
        }
    }
}

