/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.junit.platform.engine;

import io.cucumber.core.eventbus.EventBus;
import io.cucumber.core.gherkin.Feature;
import io.cucumber.core.gherkin.Pickle;
import io.cucumber.core.plugin.Options;
import io.cucumber.core.plugin.PluginFactory;
import io.cucumber.core.plugin.Plugins;
import io.cucumber.core.runner.Runner;
import io.cucumber.core.runtime.BackendServiceLoader;
import io.cucumber.core.runtime.BackendSupplier;
import io.cucumber.core.runtime.ObjectFactoryServiceLoader;
import io.cucumber.core.runtime.ObjectFactorySupplier;
import io.cucumber.core.runtime.RunnerSupplier;
import io.cucumber.core.runtime.ScanningTypeRegistryConfigurerSupplier;
import io.cucumber.core.runtime.SingletonObjectFactorySupplier;
import io.cucumber.core.runtime.SingletonRunnerSupplier;
import io.cucumber.core.runtime.ThreadLocalObjectFactorySupplier;
import io.cucumber.core.runtime.ThreadLocalRunnerSupplier;
import io.cucumber.core.runtime.TimeServiceEventBus;
import io.cucumber.core.runtime.TypeRegistryConfigurerSupplier;
import io.cucumber.junit.platform.engine.CucumberEngineOptions;
import io.cucumber.junit.platform.engine.TestCaseResultObserver;
import io.cucumber.plugin.event.Event;
import io.cucumber.plugin.event.EventPublisher;
import io.cucumber.plugin.event.TestRunFinished;
import io.cucumber.plugin.event.TestRunStarted;
import io.cucumber.plugin.event.TestSourceRead;
import java.time.Clock;
import java.util.UUID;
import java.util.function.Supplier;
import org.apiguardian.api.API;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.engine.ConfigurationParameters;
import org.junit.platform.engine.support.hierarchical.EngineExecutionContext;

@API(status=API.Status.STABLE)
public final class CucumberEngineExecutionContext
implements EngineExecutionContext {
    private static final Logger logger = LoggerFactory.getLogger(CucumberEngineExecutionContext.class);
    private final RunnerSupplier runnerSupplier;
    private final EventBus bus;

    CucumberEngineExecutionContext(ConfigurationParameters configurationParameters) {
        Supplier<ClassLoader> classLoader = CucumberEngineExecutionContext.class::getClassLoader;
        logger.debug(() -> "Parsing options");
        CucumberEngineOptions options = new CucumberEngineOptions(configurationParameters);
        ObjectFactoryServiceLoader objectFactoryServiceLoader = new ObjectFactoryServiceLoader((io.cucumber.core.backend.Options)options);
        this.bus = new TimeServiceEventBus(Clock.systemUTC(), UUID::randomUUID);
        ScanningTypeRegistryConfigurerSupplier typeRegistryConfigurerSupplier = new ScanningTypeRegistryConfigurerSupplier(classLoader, (io.cucumber.core.runner.Options)options);
        Plugins plugins = new Plugins(new PluginFactory(), (Options)options);
        if (options.isParallelExecutionEnabled()) {
            plugins.setSerialEventBusOnEventListenerPlugins((EventPublisher)this.bus);
            ThreadLocalObjectFactorySupplier objectFactorySupplier = new ThreadLocalObjectFactorySupplier(objectFactoryServiceLoader);
            BackendServiceLoader backendSupplier = new BackendServiceLoader(classLoader, (ObjectFactorySupplier)objectFactorySupplier);
            this.runnerSupplier = new ThreadLocalRunnerSupplier((io.cucumber.core.runner.Options)options, this.bus, (BackendSupplier)backendSupplier, (ObjectFactorySupplier)objectFactorySupplier, (TypeRegistryConfigurerSupplier)typeRegistryConfigurerSupplier);
        } else {
            plugins.setEventBusOnEventListenerPlugins((EventPublisher)this.bus);
            SingletonObjectFactorySupplier objectFactorySupplier = new SingletonObjectFactorySupplier(objectFactoryServiceLoader);
            BackendServiceLoader backendSupplier = new BackendServiceLoader(classLoader, (ObjectFactorySupplier)objectFactorySupplier);
            this.runnerSupplier = new SingletonRunnerSupplier((io.cucumber.core.runner.Options)options, this.bus, (BackendSupplier)backendSupplier, (ObjectFactorySupplier)objectFactorySupplier, (TypeRegistryConfigurerSupplier)typeRegistryConfigurerSupplier);
        }
    }

    void startTestRun() {
        logger.debug(() -> "Sending run test started event");
        this.bus.send((Event)new TestRunStarted(this.bus.getInstant()));
    }

    void beforeFeature(Feature feature) {
        logger.debug(() -> "Sending test source read event for " + feature.getUri());
        this.getRunner().getBus().send((Event)new TestSourceRead(this.bus.getInstant(), feature.getUri(), feature.getSource()));
    }

    void runTestCase(Pickle pickle) {
        Runner runner = this.getRunner();
        try (TestCaseResultObserver observer = TestCaseResultObserver.observe(runner.getBus());){
            logger.debug(() -> "Executing test case " + pickle.getName());
            runner.runPickle(pickle);
            logger.debug(() -> "Finished test case " + pickle.getName());
            observer.assertTestCasePassed();
        }
    }

    void finishTestRun() {
        logger.debug(() -> "Sending test run finished event");
        this.bus.send((Event)new TestRunFinished(this.bus.getInstant()));
    }

    private Runner getRunner() {
        try {
            return this.runnerSupplier.get();
        }
        catch (Throwable e) {
            logger.error(e, () -> "Unable to start Cucumber");
            throw e;
        }
    }
}

