/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.java8;

import io.cucumber.core.backend.Backend;
import io.cucumber.core.backend.Container;
import io.cucumber.core.backend.Glue;
import io.cucumber.core.backend.Lookup;
import io.cucumber.core.backend.Snippet;
import io.cucumber.core.resource.ClasspathScanner;
import io.cucumber.core.resource.ClasspathSupport;
import io.cucumber.java8.ClosureAwareGlueRegistry;
import io.cucumber.java8.Java8Snippet;
import io.cucumber.java8.LambdaGlue;
import io.cucumber.java8.LambdaGlueRegistry;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;

final class Java8Backend
implements Backend {
    private final Lookup lookup;
    private final Container container;
    private final ClasspathScanner classFinder;
    private final List<Class<? extends LambdaGlue>> lambdaGlueClasses = new ArrayList<Class<? extends LambdaGlue>>();
    private ClosureAwareGlueRegistry glue;

    Java8Backend(Lookup lookup, Container container, Supplier<ClassLoader> classLoaderProvider) {
        this.container = container;
        this.lookup = lookup;
        this.classFinder = new ClasspathScanner(classLoaderProvider);
    }

    public void loadGlue(Glue glue, List<URI> gluePaths) {
        this.glue = new ClosureAwareGlueRegistry(glue);
        gluePaths.stream().filter(gluePath -> "classpath".equals(gluePath.getScheme())).map(ClasspathSupport::packageName).map(basePackageName -> this.classFinder.scanForSubClassesInPackage(basePackageName, LambdaGlue.class)).flatMap(Collection::stream).filter(glueClass -> !glueClass.isInterface()).filter(glueClass -> glueClass.getConstructors().length > 0).distinct().forEach(glueClass -> {
            this.container.addClass(glueClass);
            this.lambdaGlueClasses.add((Class<? extends LambdaGlue>)glueClass);
        });
    }

    public void buildWorld() {
        this.glue.startRegistration();
        LambdaGlueRegistry.INSTANCE.set(this.glue);
        for (Class<? extends LambdaGlue> lambdaGlueClass : this.lambdaGlueClasses) {
            this.lookup.getInstance(lambdaGlueClass);
        }
        LambdaGlueRegistry.INSTANCE.set(LambdaGlueRegistry.CLOSED);
        this.glue.finishRegistration();
    }

    public void disposeWorld() {
        this.glue.disposeClosures();
    }

    public Snippet getSnippet() {
        return new Java8Snippet();
    }
}

